%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Information about version of Curry2Prolog.

:- module(version,[compilerVersion/1,
		   compilerMajorVersion/2, compilerMinorVersion/1,
		   printPakcsHeader/0]).

:- use_module(prologbasics).
:- use_module(basics).

% Included in headers of compiler Prolog files.
% Used to check already compiled Prolog files for correct
% version w.r.t. run-time system
compilerVersion('PAKCS1.7V4').

compilerMajorVersion(1,7).
compilerMinorVersion(3).
buildVersion(13).
buildDate('10/11/06').

printVersion :-
	compilerMajorVersion(V1,V2), compilerMinorVersion(V3),
	writeNQ(V1), writeNQ('.'),
	writeNQ(V2), writeNQ('.'),
	writeNQ(V3), writeNQ(' ('),
	buildVersion(B),
	writeNQ(B), writeNQ(')').
			    
	
printPakcsHeader :-
	prolog(Prolog),
	writeNQ('  ______      __       _    _    ______   _______     '), nlNQ,
	writeNQ(' |  __  |    /  \\     | |  / /  |  ____| |  _____|   Portland Aachen Kiel'), nlNQ,
	writeNQ(' | |  | |   / /\\ \\    | |_/ /   | |      | |_____    Curry System'), nlNQ,
	writeNQ(' | |__| |  / /__\\ \\   |  _  |   | |      |_____  |   '), nlNQ,
	writeNQ(' |  ____| / ______ \\  | | \\ \\   | |____   _____| |   Version '), printVersion, nlNQ,
	writeNQ(' |_|     /_/      \\_\\ |_|  \\_\\  |______| |_______|   November 2006'), nlNQ,
	nlNQ,
        writeNQ('Curry2Prolog('), writeNQ(Prolog),
	writeNQ(') Compiler Environment (Version of '),
	buildDate(BD), writeNQ(BD), writeNQ(')'), nlNQ,
	writeNQ('(RWTH Aachen, CAU Kiel, Portland State University)'), nlNQ,
	nlNQ,
	writeNQ('Bug reports: mh@informatik.uni-kiel.de'), nlNQ,
	nlNQ,
	writeNQ('Type ":h" for help'), nlNQ,
	nlNQ.
