-- A simple demo for dynamic reconfiguration of widget options:

import Tk

widget =
 TkCol [] [
   TkLabel [TkText "Text of buttons below:"],
   TkEntryScroll [TkRef tentry, TkText "Stop", TkBackground "white",
                  TkConfigCmd changetext],
   TkLabel [TkText "Background color of exit button below:"],
   TkRow []
     [TkEntry [TkRef centry, TkText "red", TkBackground "white",
               TkConfigCmd changecolor],
      TkPlainButton [TkConfigCmd changecolorp, TkText "Select from palette"]],
   TkCheckButton [TkRef actbutton, TkText "Deactivate buttons below",
                  TkConfigCmd deactivate],
   TkButton (\_->putStrLn "XXX") [TkRef prtbutton, TkText "Print 'XXX'"],
   TkButton tkExit [TkRef stopbutton, TkText "Stop", TkBackground "red"]]

  where
    tentry,centry,actbutton,prtbutton,stopbutton free

    changetext wp = do
       text <- tkGetValue tentry wp
       tkFocus centry wp
       return [(stopbutton,TkText text), -- change button text
               (prtbutton,TkText ("Print '"++text++"'")), -- change button text
               (prtbutton,TkCmd (\_->putStrLn text))] -- change button command

    changecolor wp = do
       color <- tkGetValue centry wp
       return [(stopbutton,TkBackground color)]

    changecolorp _ = do
       color <- tkChooseColor
       return [(stopbutton,TkBackground color)]

    deactivate wp = do
       act <- tkGetValue actbutton wp
       return [(stopbutton,TkActive (act=="0")),
               (prtbutton,TkText ""),
               (prtbutton,TkCmd (\_->done))]


main = runWidget "Config Demo" widget

