--- Library for accessing the directory structure of the
--- underlying operating system.
---
--- @author Michael Hanus
--- @version September 2006

module Directory(doesFileExist,doesDirectoryExist,fileSize,
                 getModificationTime,getDirectoryContents,
                 createDirectory) where


--- Returns true if the argument is the name of an existing file.
doesFileExist :: String -> IO Bool
doesFileExist fname = prim_doesFileExist $## fname

prim_doesFileExist :: String -> IO Bool
prim_doesFileExist external

--- Returns true if the argument is the name of an existing directory.
doesDirectoryExist :: String -> IO Bool
doesDirectoryExist dir = prim_doesDirectoryExist $## dir

prim_doesDirectoryExist :: String -> IO Bool
prim_doesDirectoryExist external

--- Returns the size of the file.
fileSize :: String -> IO Int
fileSize fname = prim_fileSize $## fname

prim_fileSize :: String -> IO Int
prim_fileSize external

--- Returns the modification time of the file.
getModificationTime :: String -> IO Int
getModificationTime fname = prim_getModificationTime $## fname

prim_getModificationTime :: String -> IO Int
prim_getModificationTime external

--- Returns the list of all entries in a directory.
getDirectoryContents :: String -> IO [String]
getDirectoryContents dir = prim_getDirectoryContents $## dir

prim_getDirectoryContents :: String -> IO [String]
prim_getDirectoryContents external

--- Creates a new directory with the given name.
createDirectory :: String -> IO ()
createDirectory dir = prim_createDirectory $## dir

prim_createDirectory :: String -> IO ()
prim_createDirectory external

--- Deletes a file from the file system.
removeFile :: String -> IO ()
removeFile dir = prim_removeFile $## dir

prim_removeFile :: String -> IO ()
prim_removeFile external

