------------------------------------------------------------------------------
--- Library to access parts of the system environment.
---
--- @author Michael Hanus
--- @version October 2005
------------------------------------------------------------------------------

module System(Date(..),getDate,showDate,getCPUTime,getElapsedTime,
              getArgs,getEnviron,getHostname,getPID,getProgName,
              system,exitWith,
              sleep,evalTime,evalSpace) where

import FileGoodies

--- A date is presented in the following form:
--- (Date year month day hour minute second)
--- This type will not be supported in the future.
--- Use type Time.ClockTime!

data Date = Date Int Int Int Int Int Int

--- Returns the current date and time.
--- This function will not be supported in the future.
--- Use function Time.getClockTime!

getDate :: IO Date
getDate external

--- Transform a date into a readable form.
--- This function will not be supported in the future.
--- Use function Time.toDateString!

showDate :: Date -> String
showDate (Date y mo d h mi s) = digit2 mo ++"/"++ digit2 d ++"/"++ show y
                                ++ " " ++
                                digit2 h ++":"++ digit2 mi ++":"++ digit2 s
  where digit2 n = if n<10 then ['0',chr(ord '0' + n)]
                           else show n

--- Returns the current cpu time of the process in milliseconds.

getCPUTime :: IO Int
getCPUTime external
 
--- Returns the current elapsed time of the process in milliseconds.

getElapsedTime :: IO Int
getElapsedTime external
 
--- Returns the list of the program's command line arguments.
--- The program name is not included.

getArgs :: IO [String]
getArgs external
 
--- Returns the value of an environment variable.
--- The empty string is returned for undefined environment variables.

getEnviron :: String -> IO String
getEnviron evar = seq (groundNormalForm evar) (prim_getEnviron evar)
 
prim_getEnviron :: String -> IO String
prim_getEnviron external
 
--- Returns the hostname of the machine running this process.

getHostname :: IO String
getHostname external

--- Returns the process identifier of the current Curry process.

getPID :: IO Int
getPID external


--- Returns the name of the current program, i.e., the name of the
--- main module currently executed.

getProgName :: IO String
getProgName external


--- Executes a shell command and return with the exit code of the command.
--- An exit status of zero means successful execution.

system :: String -> IO Int
system cmd = seq (groundNormalForm cmd) (prim_system cmd)

prim_system :: String -> IO Int
prim_system external


--- Terminates the execution of the current Curry program
--- and returns the exit code given by the argument.
--- An exit code of zero means successful execution.

exitWith :: Int -> IO _
exitWith exitcode = seq (ensureNotFree exitcode) (prim_exitWith exitcode)

prim_exitWith :: Int -> IO _
prim_exitWith external


--- The evaluation of the action (sleep n) puts the Curry process
--- asleep for n seconds.

sleep :: Int -> IO ()
sleep n = seq (ensureNotFree n) (prim_sleep n)

prim_sleep :: Int -> IO ()
prim_sleep external

--- Evaluates the argument to normal form (and return the normal form)
--- and print the time needed for this evaluation on standard error.

evalTime :: a -> a
evalTime external

--- Evaluates the argument to normal form (and return the normal form)
--- and print the time and space needed for this evaluation on standard error.
--- During the evaluation, the garbage collector is turned off.

evalSpace :: a -> a
evalSpace external

