-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
--
-- A small program for generating flat xml representations for curry files.
-- The flat xml files are generated by executing "cymake" and "cyc" on the
-- specified curry file. Import dependencies are resolved automatically.
--
-- January 2005,
-- Martin Engelke (men@informatik.uni-kiel.de)
--

import System
import Directory


-------------------------------------------------------------------------------

-- Call 
--    cyxml <filename>
--
-- <filename> must be a curry file (with suffix ".curry").
-- The function generates corresponding object files (".o"),
-- interface files (".icurry") and a flat xml file (".flat") for
-- the specified curry file.
main :: IO ()
main
   = do file <- getFilename
	fileExist <- doesFileExist file
	suffix <- return (getSuffix file)
	if fileExist
	   then if suffix == "curry" || suffix == "lcurry"
		then generateFlatXML (take ((length file) 
					    - (1 + length suffix)) file)
		else raiseError ("not a curry file: \"" ++ file ++ "\"")
	   else raiseError ("file \"" ++ file ++ "\" does not exist")


-------------------------------------------------------------------------------
-------------------------------------------------------------------------------

generateFlatXML :: String -> IO()
generateFlatXML name
   = do code1 <- system (cymake ++ name ++ ".curry")
	checkExitCode code1 "no flat xml file generated"
	putStrLn ("Generating \"" ++ name ++ ".flat\"...")
	code2 <- system (cyc ++ "--flat " ++ name ++ ".curry")
	checkExitCode code2 "no flat xml file generated"
	putStrLn "...done"


cymake :: String
cymake = "/home/mh/lehrstuhl/frontend/mcc/bin/cymake "

cyc :: String
cyc = "/home/mh/lehrstuhl/frontend/mcc/bin/cyc "

-------------------------------------------------------------------------------

getFilename :: IO String
getFilename
   = do args <- getArgs
        if null args
	   then raiseError "cyxml: missing filename"
           else return (head args)


getSuffix :: String -> String
getSuffix file = reverse (takeWhile ((/=) '.') (reverse file))


raiseError :: String -> IO a
raiseError reason
   = do putStrLn ("cyxml - " ++ reason)
	exitFailure


checkExitCode :: ExitCode -> String -> IO ()
checkExitCode exitcode reason
   = case exitcode of
       ExitSuccess -> putStr ""
       _           -> putStrLn ("cyxml - " ++ reason) >> exitWith exitcode


-------------------------------------------------------------------------------
-------------------------------------------------------------------------------
