% hier geaendert:
% writeResult, showResult, ...
% neues Praedikat: unrename.


% Currytools: Listen- und Termtools

%if mit cut.
ifc(Bed,Then,Else):-Bed->Then;Else.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Tools

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% writeNames(X)
%
% - writes X to the screen with variable names replaced by letters

writeNames(X):-
        (\+ \+ (numbervars(X,0,_),
                tabwrite([X],[]))).

tabwrite([],_Tab).
tabwrite([branch(Pat,X,Flag,T)|Ts],Tab):-
  doTab(Tab),write('branch: '),write(Pat),write(','),write(X),
   write(','),write(Flag),nl,
  tabwrite(T,[0|Tab]),
  tabwrite(Ts,Tab).  
tabwrite([or(L,R)|Ts],Tab):-
  doTab(Tab),write('or'),nl,
  tabwrite([L],[0|Tab]),
  tabwrite([R],[0|Tab]),
  tabwrite(Ts,Tab).
tabwrite([rule(L,R)|Ts],Tab):-
  doTab(Tab),write('rule('),write(L),write(','),write(R),write(')'),nl,
  tabwrite(Ts,Tab).
tabwrite([X],_Tab):-
  write(X).

doTab([]).
doTab([0|X]):- 
  write('   '),doTab(X).

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% showResult(List)
%
% - List contains Curry-goals of type (VarList,Substitution,Term)
%   Display them all.

showResult([], _):-
  write('No solution.'),nl.
showResult([X], NT):-
	 \+ \+ (numbervars(X,0,_),writeResult(X, NT)).
%numberVars gibt den temporaeren Variablen Namen fuer die Ausgabe
showResult([X|Xs], NT):-
	\+ \+ (numbervars(X,0,_),writeResult(X, NT),write( ' | '),showResult(Xs,NT)).

%--------------

writeResult((_V,[],G),NT) :- 
  !, 
  (G==suspend({}) -> write('{}') ; writeGoal(G,NT)).
writeResult((_V,S,G),NT) :- 
  write('{'), 
  writeSubst(S,NT), 
  writeGoal(G,NT).
    
writeSubst([X/S],NT):-
  unrename(S, NewS, NT), 
  write(X),
  write('='),
  write(NewS),
  write('} ').
writeSubst([X/S|Xs],NT):-
  unrename(S, NewS, NT), 
  write(X),
  write('='),
  write(NewS),
  write(','),
  writeSubst(Xs,NT).

writeGoal(suspend('$io'(_)),_) :- !.   % do not print interal I/O action
writeGoal({},_) :- !.
writeGoal(suspend({}),_) :- !.
writeGoal(suspend(G), NT):-
  !,
  unrename(G, NewG, NT), 
  write(NewG).
writeGoal(G, NT):-
  unrename(G, NewG, NT), 
  write(NewG).



% should be in the modsys; but it is needed by writeResult.


unrename(A, B, C):- unrename2(A,B,C).

unrename2(Term, Term,_):-        %removes module prefixes

  var(Term),
  !.

unrename2(internalPort(H,N,_), internalPort(H,N),_) :- !.  % ignore ports

unrename2(Term, NewTerm, NameTable):-
  Term=..[Head|Args],
  if(
       member((Orig, Head), NameTable),
       NewHead=Orig,
       (
	  name(Head, AsciiHead),
	  if(
	       (
		  safe(root_module(ROOT)),
		  append(ROOT, [95|Rest], AsciiHead),
		  name(NR, Rest)
	       ),
	       NewHead=NR,
	       NewHead=Head
	    )
       )
    ),
  !,
  unrenameArgs2(Args, [], NewArgs, NameTable),
  NewTerm=..[NewHead|NewArgs].

unrenameArgs2([], A, A, _).
unrenameArgs2([A|As], Accu, NewArgs, NameTable):-
  unrename2(A, NewA, NameTable),
  append(Accu, [NewA], TmpArgs),
  unrenameArgs2(As, TmpArgs, NewArgs, NameTable).




% remove everything in front of an '_' ...  

unrename3(Term, Term,_):-        %entfernt Modulpraefixe
  var(Term),
  !.

unrename3(Term, NewTerm, NameTable):-
  Term=..[Head|Args],
  if(
       member((Orig, Head), NameTable),
       NewHead=Orig,
       (
	  name(Head, AsciiHead),
	  if(
	       (
		  append(_, [95|Rest], AsciiHead),
		  name(NR, Rest)
	       ),
	       (!, NewHead=NR),
	       (!, NewHead=Head)
	    )
       )
    ),
  !,
  unrenameArgs3(Args, [], NewArgs, NameTable),
  NewTerm=..[NewHead|NewArgs].

unrenameArgs3([], A, A, _).
unrenameArgs3([A|As], Accu, NewArgs, NameTable):-
  unrename3(A, NewA, NameTable),
  append(Accu, [NewA], TmpArgs),
  unrenameArgs3(As, TmpArgs, NewArgs, NameTable).



%%%%%%%%%%%%%%%%%%%%%%%%%%%
% makeNames(list1,List2)
%
% - the prolog-order "read" returns a list of all variables contained in the
%   term read. The list contains the name of the variable as the user 
%   specified it, and the internal representation.
% - makeNames unifies name and internal representation, so one can display
%   the term with the real names-

makeNames([],[]).
makeNames([X=Y|Xs],[Y|Ys]) :- % Y might be instantiated by external funcs
	(var(Y) -> X=Y ; true), makeNames(Xs,Ys).

%%%%%%%%%%%%%%%%%%%%%%%%%%%
% clearResult(ListOfGoals, ListOfVariableNames,NewListOfGoals)
%
% - clearResult removes from the substitution of a goal:
%   a) X/X -susbtitutions
%   b) all variables that appear not in the ListOfVariableNames, which
%      is the list we got from reading in the initial goal
% - We do this to display only the substitution of those variables
%   which were in the initial goal the user typed in


clearResult([],_,[]).
clearResult([(V,Subst,Goal)|Xs],Liste,[(V,NewSubst,Goal)|Ys]):-
        clearSubst(Subst,Liste,NewSubst),
        clearResult(Xs,Liste,Ys).

clearSubst([],_,[]).
clearSubst([(X/Y)|Xs],Liste,Ys):-
        X==Y,!,clearSubst(Xs,Liste,Ys).
clearSubst([(X/Y)|Xs],Liste,[(X/Y)|Ys]):-
        memberInVarListSecond(X,Liste),!,clearSubst(Xs,Liste,Ys).
clearSubst([_|Xs],Liste,Ys):-clearSubst(Xs,Liste,Ys).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Tools for collecting and naming variables that appear during computation


%%%%%%%%%%%%%%%%%%%%%%%%
% collectNewVars(ListOfResults,ListOfVariableNames,N,NewListOfVariableNames)
%
% - scans all results, (VarList,Substitution,Goal), for new variables
%   that arised during computation. Then create new unique names and
%   add them to the ListOfVariableNames which is initially the list 
%   that we got from reading in the users goal.
%   This list is used for displaying the result while computing if the
%   trace-option is on. Collecting the new variables after each step
%   guarantees that also the variables that appear during computation 
%   are alwasy display with the same name during the whole computation.

collectNewVars(Result,List,N,NewList):-
        collectNewVars(Result,List,N,_NewN,NewList).

collectNewVars([],List,N,N,List).

collectNewVars([(_V,Subst,Goal)|Xs],List,N,NewN,NewList):- 
        collectNewVarsForTerm(Goal,List,N,NewN1,NewList1),       %search single goal
        collectNewVarsForSubst(Subst,NewList1,NewN1,NewN2,NewList2),
        collectNewVars(Xs,NewList2,NewN2,NewN,NewList).


collectNewVarsForSubst([],List,N,N,List).
collectNewVarsForSubst([(X/Y)|Xs],List,N,NewN,NewList):-
        if(memberInVarListSecond(X,List),      % does X it already exist in list?
           (NewList1=List,NewN1=N),
           (makeNewVarName(List,N,NewName,NewN1),   %if not, create a symbolic name
            append(List,[NewName=X],NewList1))), %and add to list
        collectNewVarsForTerm(Y,NewList1,NewN1,NewN2,NewList2),
        collectNewVarsForSubst(Xs,NewList2,NewN2,NewN,NewList).
%Y must be checked too, for it might be a term that contains variables that
%do not appear in any goal, e.g. in a result {X/s(A),true}


collectNewVarsForTerm(Term,List,N,NewN,NewList):-
        var(Term),!,                        % term is a variable
        if(memberInVarListSecond(Term,List),      % does it already exist in list?
           (NewList=List,NewN=N),
           (makeNewVarName(List,N,NewName,NewN),   %if not, create a symbolic name
            append(List,[NewName=Term],NewList))). %and add to list

collectNewVarsForTerm(internalPort(_,_,_),List,N,N,List):-
	!. % don't look into internal ports
collectNewVarsForTerm(Term,List,N,NewN,NewList):-
        Term=..[_|Args],
        collectNewVarsArglist(Args,List,N,NewN,NewList).

collectNewVarsArglist([],List,N,N,List).
collectNewVarsArglist([X|Xs],List,N,NewN,NewList):-
        collectNewVarsForTerm(X,List,N,NewN1,NewList1),
        collectNewVarsArglist(Xs,NewList1,NewN1,NewN,NewList).





%%%%%%%%%%%%%%%%%%%%%%%%
% memberInVarListFirst(Var,ListOfVariableNames)
% 
% - checks whether a variable is member of a list of the form [A=_123,B=_42,...]
%   where the variable is of the first type, i.e. A etc.

memberInVarListFirst(Var,[X=_Y|_Xs]):-
        Var==X,!.
memberInVarListFirst(Var,[_X=_Y|Xs]):-
        memberInVarListFirst(Var,Xs).



%%%%%%%%%%%%%%%%%%%%%%%%
% memberInVarListSecond(Var,ListOfVariableNames)
%
% checks whether a variable is member of a list of the form [A=_123,B=_42,...]
% where the variable is of the second type, i.e. _123 etc.


memberInVarListSecond(Var,[_X=Y|_Xs]):-
        Var==Y,!.
memberInVarListSecond(Var,[_X=_Y|Xs]):-
        memberInVarListSecond(Var,Xs).



%%%%%%%%%%%%%%%%%%%%%%%%
% makeNewVarName(List,N,Name,NewN)
%
% gets a list of variable names and creates a new one that is not
% in the list. The names are created according to numbervars, i.e.
% A,B,...Z,A1,B1,...,A2,B2,...
% The principle is: create (A+(N mod 64))(N//64)
% when N is set to 0.
% give back NewN as the next higher number than N.

        
makeNewVarName(List,N,Name,NewN):-       
        NFirst is (N mod 26)+65,   %First part: the letter
        NSecond is N // 26,        %second part: the number
        if(NSecond==0,
           name(Test,[NFirst]),
           (name(NSecond,H1),
            append([NFirst],H1,H2),
            name(Test,H2))),
        if(memberInVarListFirst(Test,List),
           (N1 is N+1,
            makeNewVarName(List,N1,Name,NewN)),
           (Name=Test,NewN is N+1)).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% List Tools

%%%%%%%%%%%%%%%%%%
% nobound(List)
%
% - checks if each element of the list is a variable

nobound([]).
nobound([X|Xs]):-var(X),nobound(Xs).


%%%%%%%%%%%%%%%%%%
% makeNewVarList(N,List)
%
% - creates a list of N new variables

makeNewVarList(0,[]):-!.
makeNewVarList(N,[_|Xs]):-
        N1 is N-1,
        makeNewVarList(N1,Xs).


%%%%%%%%%%%%%%%%%
% ith(List,I,Element)
%
% - ith-element of a list.
% - counting starts with 1.

ith([X|_],1,Y):-!,Y=X.
ith([_|Xs],N,Y):-N1 is N-1,ith(Xs,N1,Y).


%%%%%%%%%%%%%%%%%
% member without unifikation
strictmember(X,[Y|_]):-X==Y.
strictmember(X,[_|Ys]):-strictmember(X,Ys).


%remove(A,B,C)
%remove all members of B from A. Result in C
%remove(Xs,[],Xs).
%remove(Xs,[Y|Ys],E):-
%	remove2(Xs,Y,E2),
%	remove(E2,Ys,E).

%remove2(A,B,C)
%remove all appearances of B from A
%remove2([],_,[]).
%remove2([Y|Xs],Y,E):-remove2(Xs,Y,E).
%remove2([X|Xs],Y,[X|E]):-remove2(Xs,Y,E).

%%%%%%%%%%%%%%%%%
% removeVarFromSet(X,Set,NewSet)
%
% - removes a variable X from a set of variable Set.

removeVarFromSet(_X,[],[]).
removeVarFromSet(X,[Y|Ys],Ys):-X==Y.
removeVarFromSet(X,[Y|Ys],[Y|Zs]):-removeVarFromSet(X,Ys,Zs).



%%%%%%%%%%%%%%%%%%%%%
% Substitions- und Unifikationstools
%%%%%%%%%%%%%%%%%%%%


% Stelle-ten Teilterm liefern. Stellen werden als 1, 1#1#2 etc def.
teilterm(Term,Stelle,Teilterm):-
        nonvar(Term),
        Term=..[_|Args],
        if(Stelle=A#B,
           (ith(Args,A,TeiltermA),
            teilterm(TeiltermA,B,Teilterm)),
           ith(Args,Stelle,Teilterm)).


%ersetzt den Teilterm in Term an Stelle durch den Substterm
substTerm(Term,Stelle,SubstTerm,NewTerm):-
        nonvar(Term),
        Term=..[Head|Args],
        if(Stelle=A#B,
           (takeTillStelle(Args,A,HeadList,StelleArg,TailList),
            substTerm(StelleArg,B,SubstTerm,NewTerm1)),
           (takeTillStelle(Args,Stelle,HeadList,StelleArg,TailList),
            NewTerm1=SubstTerm)),
        append(HeadList,[NewTerm1],Help1),
        append(Help1,TailList,Help2),
        NewTerm=..[Head|Help2].


%zerteilt eine Liste in drei Teile: Das Element an Stelle (numerischer Wert),
% und die beiden Teillisten rechts und links davon.
takeTillStelle([X|Xs],Stelle,HeadList,StelleArg,TailList) :-
        if(Stelle=1,
           (HeadList=[],
            StelleArg=X,
            TailList=Xs),
           (NewStelle is Stelle-1,
            takeTillStelle(Xs,NewStelle,HeadList1,StelleArg,TailList),
            append([X],HeadList1,HeadList))).





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% unify(L,T,VarList,NewVarList,Subst)
%
% - unifies L with T. Variable-bindings are given back in Subst.
% - VarList contains all variables of T (and perhaps more). If a
%   variable from T is bound, remove it from VarList. 
%   VarList contains no variables of L. If such a variable is bound,
%   leave VarList unchanged. But if a variable of T is bound to a
%   subterm of L, add all variables of this subterm to VarList.
%   This is done, because L is a left side of a rule.
%   After unifying L with T, we will replace T by the right side of
%   the rule. All variables of the left side can appear in the right
%   side, so add them to VarList. Variables of T can be transported
%   into the right side, if a variable of L is bound to a subterm
%   of T that contains variables. But if a variable of T is bound,
%   it can definitely not appear in the right side anymore, so remove it.


unify(L,T,V,V,[(L/T)]):-          % L is preferred. If L and T are variables, the 
        var(L),!.                 % result is L/T and not T/L.
        
unify(L,T,V,NewV,[(T/L)]):-
        var(T),!,
        removeVarFromSet(T,V,NewV1),
        freeVars(L,LVars),
        append(LVars,NewV1,NewV).
     
unify(L,T,V,V,[]):-L==T,!.         % L and T are no variables and identical.  
unify(L,T,V,NewV,ErgTail):-
        L=..[Head|LTail],
        T=..[Head|TTail],
        unifyList(LTail,TTail,V,NewV,ErgTail),!.


% found unifications are applied to the restlist of arguments to avoid
% different bindings of the same variable
unifyList([],[],V,V,[]).
unifyList([X|Xs],[Y|Ys],V,NewV,ResultSubst):-
        unify(X,Y,V,NewV1,Subst),!,
        substituteList(Xs,Subst,Xs2),
        substituteList(Ys,Subst,Ys2),
        unifyList(Xs2,Ys2,NewV1,NewV,RestSubst),
        appendSubst(Subst,RestSubst,ResultSubst).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%leftUnify(L,T,Subst)
%
% - generates a substitution s, so that s(L)=T.


leftUnify(X,Y,[]):-X==Y,!.
leftUnify(X,Y,[(X/Y)]):-var(X),!.
leftUnify(_,Y,[]):-
        var(Y),!,fail.
leftUnify(X,Y,ErgTail):-
        X=..[Head|XTail],
        Y=..[Head|YTail],
        leftUnifyList(XTail,YTail,ErgTail),!.


leftUnifyList([],[],[]).
leftUnifyList([X|Xs],[Y|Ys],Unifylist):-
        leftUnify(X,Y,Erg),
        substituteList(Xs,Erg,Xs2),
        substituteList(Ys,Erg,Ys2),
        leftUnifyList(Xs2,Ys2,Erglist),!,
        appendSubst(Erg,Erglist,Unifylist).


variants(X,Y):-
\+ 
\+ 
(numbervars(X,0,_),numbervars(Y,0,_),X==Y).



%substitutevalue liefert aus einer Substitutionsliste fuer eine
%Variable den zu substituierenden Wert
substituteValue(X,[],X1):-!,X=X1.
substituteValue(X,[(X1/Y1)|_],Y):-X==X1,!,Y=Y1.
substituteValue(X,[_|Xs],Y):-substituteValue(X,Xs,Y).


%substitute ersetzt Variablen in einem Term durch die Werte,
%die in der Substitution mituebergeben werden.

% "VarList localVars Term" wird gesondert behandelt, weil die Variablenliste nicht
% behandelt werden muss. Substitute kann einfach auf Term angewendet werden,
% weil zum Zeitpunkt der Anwendung in der Substitution kein Variablenname
% vorkommen kann, der in VarList steht (siehe Notizen dazu).

substitute(Term,[],Term1):-Term=Term1,!.
substitute(Term,Substlist,NeuTerm):-
        var(Term),!,substituteValue(Term,Substlist,NeuTerm).
substitute(List localVars Term,SubstList,List localVars NeuTerm):-
        substitute(Term,SubstList,NeuTerm).
substitute(Term,Substlist,NeuTerm):-
        Term=..[Head|Tail],
        substituteList(Tail,Substlist,NeuTail),
        NeuTerm=..[Head|NeuTail].

% substituteList wendet auf jeden Term einer Termliste die Substitution an und liefert
% die Liste der substituierten Terme zurueck
substituteList([],_,[]).
substituteList([X|Xs],Substlist,[Y|Ys]):-
        substitute(X,Substlist,Y),
        substituteList(Xs,Substlist,Ys).


% verknuepft zwei Substitutionen und lst dabei Zykel der
% Form X/Y, Y/1 zu X/1, Y/1 auf.
% Subst und Subst2 werden verschieden behandelt!!!!!!!!!
% Erlaubt sind appendSubst([X/Y],[Y/1],Result).
% aber nicht appendSubst([Y/1],[X/Y],Result).
% Arbeitsweise: Hole aus der zweiten Liste die erste Substitution und wende diese
% auf die erste Liste an. Fuege dann die erste Substitution zur ersten Liste hinzu.
% also: appendSubst([X/Y],[Y/Z,Z/3],Result) fuehrt zu appendSubst([Y/Z,X/Z],[Z/3],Result).
% Bindungen wie X/Y, Y/Z, Z/1 werden nicht aufgeloest, da sie nach Verwendung der Subst
% im Programm nicht vorkommen koennen. Da waere bereits einen Schritt vorher X/Y, Y/Z
% zu X/Z, Y/Z geworden.

appendSubst(Subst,[],Subst).
appendSubst([],Subst,Subst).
appendSubst(Subst,[EinzelSubs|Subst2],Subst3):-
        substituteSubstList(Subst,[EinzelSubs],Subst1),
        appendSubst([EinzelSubs|Subst1],Subst2,Subst3).


substituteSubstList([],_,[]).
substituteSubstList([X/X1|Xs],EinzelSubs,[Y/Z|Result]):-X=Y,
                     substitute(X1,EinzelSubs,Z),
                     substituteSubstList(Xs,EinzelSubs,Result).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% makeSubstForLocalVars(VarList,Subst,NewVars)
%
% - VarList os a list of variables. For each X in VarList add (X/X_fresh)
%   to Subst with X_fresh a fresh variable and add X_fresh to NewVars.
%   Used by cseX(VarList localInPar T).

makeSubstForLocalVars([],[],[]).
makeSubstForLocalVars([X|Xs],[(X/X_fresh)|Subst],[X_fresh|Locals]):-
        makeSubstForLocalVars(Xs,Subst,Locals).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% reducedTerm
%
% - tests, if the Term is completely reduced, i.e. it containts no
%   function symbols than can be evaluated. A partial call $f(t1..tn) is reduced
%   if the ti are reduced, because this f cannot be evaluated before the missing
%   parameter is added.

reducedTerm(X):-var(X),!.
reducedTerm(T):-
        T=..[Head|Args],!,
        testHead(Head,Args,NewArgs),
        reducedTermList(NewArgs).

testHead($,[F],Args):-!,
        F=..[_|Args].
testHead(Head,Args,Args):-!,isCons(Head,_).

reducedTermList([]).
reducedTermList([X|Xs]):-reducedTerm(X),!,reducedTermList(Xs).




groundTerm(T):-nonvar(T),
        T=..[Head|Args],
        isCons(Head,_),!,
        groundTermList(Args).

groundTermList([]).
groundTermList([X|Xs]):-groundTerm(X),!,groundTermList(Xs).


