:-module(io, [readImplAndGenIntrf/5, readInterface/5, readImplementation/5, readImplementation2/2, print_error/1, printGIL/1, printList/4, parseImport/3]).

:-use_module(library(ordsets)).
:-use_module(ownlists).
%:-use_module(operators).    %previously imported
:-use_module(library(lists)).
%:-use_module(filesystem). % deleted due to cyclic definition (MH)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%%%%%
%%%%%    1. file-I/O
%%%%%
%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%:- op(1150,fx, (operator)).
:- op(1150,fx,(import)).
:- op(1150,fx, (interface)).
%:- op(1151,fx, (implementation)).
:- op(1150,fx,(module)).
:- op(1150,fx,(endmodule)).
                   %:- op(1150, fx, (renaming)).
                   %:- op(1149, xfx, (to)).    %52
%:- op(1148, xfx, (in)). 
:- op(960,xfy,in).

:-op(1150,fx,import).
:-op(1149,xfy, to).
:-op(1148,xfy,renaming).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% readInterface(Token,Import,CurrentModule,NewModule,CurrentFile)
%
% looks for Import-statements in the CurrentFile in the CurrentModule.
% Token is given by readLine; if an import-statement inside a module
% is encountered, the modules to be imported are stored in "Import".
% There is an error check; e.g. readInterfaces checks whether there 
% corresponds a module-definition to an endmodule-statement, and so on.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

% import statements in interfaces:

readInterface(end_of_file,[],_,[],_):-!.
%readInterface(end_of_file,[],[],[],_):-!.
%readInterface(end_of_file,_,Mod,Mod,File):-
%	format("\n*** Error: module '~w' in file '~w' not completed.\n",
%			[Mod, File]),
%	!,fail.

readInterface((interface M), [], [], M, CurrFile):-
  if(
       functor(M,M,0),   %no expdecls in interfaces
       (
	  !,
	  format(user_output, "reading interface '~w:~w' ...\n", 
		 [CurrFile,M]),
	  flush_output
       ),
       (
	  format(user_error,"\n*** Error: Syntax error in interface \c
				(no export declarations in \c
				interfaces).\n \c
				File: '~w', module: '~w'.\n", 
				[CurrFile, M]),
	  !,fail
       )
     ).


	


readInterface((interface M), _, CurrMod, _, CurrentFile):-
	% no module definitions in modules.
	format(user_error,"\n*** Error: Definition of module '~w' inside \c
	                   module '~w' in file '~w' not allowed.\n",
			   [M,CurrMod,CurrentFile]),
	!,fail.

readInterface((import F), _, [], [], CurrentFile):-!,
	format(user_error, "\n*** Error: import declaration outside \c
	                    modules not allowed ('~w' imported in file '~w')\n",
	                    [F,CurrentFile]),
	!,fail.
readInterface((import F), (impRen,Imports, Renamings), CurrentMod, CurrentMod, _):-
  !,
  parseImport((import F), Imports, Renamings).
%  makeListOfTuple(F, LF),
%  listifyArguments(LF, Imports).


%readInterface((endmodule), [], CurrentMod, [], CurrentFile):-
%  format(user_output, "interface '~w:~w' read ...\n", 
%  			[CurrentFile,CurrentMod]),
%  flush_output.
  %write('.').

% interface body consists not only of import statements; here we 
% are interested in the rest

readInterface((Line), _, [], [], CurrentFile):-!,
	format(user_error, "\n*** Error: Line '~w' (File ~w) out of any \c
    			    module's scope.\n",
	                    [Line, CurrentFile]),
	!,fail.

% f indicates "function"s
% d indicates "data"
% r indicates "renaming"s
% c indicates constructor. Constructors will be stored in the calling routine,
% findImports/4, in the form c(X), c(Y), ...
% 3rd and 4th comp: Module, original name

readInterface((F::T), (ibody, f(F,T,M,F)), M, M, _):-!.
readInterface((data D), (ibody, d(D)), M, M, _):-!.
%readInterface((renaming EO in Mod to EN), (ibody,r(EO,EN,Mod)), M, M, _):-!.
readInterface((infixl(Prio, Name)), (ibody, o(Name, Prio, ixl, M, Name)), M, M, _):-!.
readInterface((infix(Prio, Name)), (ibody, o(Name, Prio, ix, M, Name)), M, M, _):-!.
readInterface((infixr(Prio, Name)), (ibody, o(Name, Prio, ixr, M, Name)), M, M, _):-!.



readInterface(CL, (ibody,CL), M, M, CurrentFile):-
  format(user_error, "\n*** Error: Line '~w' is not allowed in module \c
			interfaces\n (module: '~w', file: '~w').\n",
			[CL, M, CurrentFile]),
  !,fail.




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

readImplementation(end_of_file,[],_,[],_):-!.
%readImplementation(end_of_file,[],[],[],_):-!.
%readImplementation(end_of_file,_,Mod,Mod,File):-
%	format("\n*** Error: module '~w' in file '~w' not completed.\n",
%			[Mod, File]),
%	!,fail.


	
readImplementation((module M), [], [], ModName, CurrFile):-
  !,
  functor(M, ModName, _),
  format(user_output, "reading implementation '~w:~w' ...\n", 
	 [CurrFile,ModName]),
  flush_output.

readImplementation((module M), _, CurrMod, _, CurrentFile):-
	% no module definitions in modules.
	format(user_error,"\n*** Error: Implementation of module '~w' inside \c
	                   module '~w' in file '~w' not allowed.\n",
			   [M,CurrMod,CurrentFile]),
	!,fail.

readImplementation((import F), _, [], [], CurrentFile):-!,
	format(user_error, "\n*** Error: import declaration outside \c
	                    modules not allowed ('~w' imported in file '~w')\n",
	                    [F,CurrentFile]),
	!,fail.

readImplementation((import F), (impRen, Imports, Renamings), CurrentMod, CurrentMod, _):-
  !,
  parseImport((import F), Imports, Renamings).
%  makeListOfTuple(F, LF),
%  listifyArguments(LF, Imports).


%readImplementation((endmodule), [], CurrentMod, [], CurrentFile):-
%  format(user_output, "module '~w:~w' read ...\n", 
%  			[CurrentFile,CurrentMod]),
%  flush_output.


%readImplementation((renaming EO in Mod to EN), (ibody,r(EO,EN,Mod)), M, M, _):-!.
readImplementation((infixl(Prio, Name)), (ibody, o(Name, Prio, ixl, M, Name)), M, M, _):-!.
readImplementation((infix(Prio, Name)), (ibody, o(Name, Prio, ix, M, Name)), M, M, _):-!.
readImplementation((infixr(Prio, Name)), (ibody, o(Name, Prio, ixr, M, Name)), M, M, _):-!.

readImplementation(_, [], M, M, _).  %ignore




% no error check; this has been done before
readImplementation2(end_of_file,no):-!.
readImplementation2((module M), (newMod, ModName)):-
  !, 
  functor(M, ModName,_).
readImplementation2((import _), no):-!.
%readImplementation2((endmodule), no):-!.
%readImplementation2((renaming _ in _ to _), no):-!.
readImplementation2((infixl(_, _)), no):-!.
readImplementation2((infix(_, _)), no):-!.
readImplementation2((infixr(_, _)), no):-!.
%readImplementation2((export _), no):-!.
readImplementation2(L, L).  %copy
    




readImplAndGenIntrf(end_of_file,[],_,[],_):-!.

readImplAndGenIntrf((module M), Exports, [], ModName, CurrFile):-
  !,
  functor(M,ModName,NumArgs),
  format(user_output, "substituting interface '~w:~w' ...\n", 
		 [CurrFile,ModName]),
  flush_output,
  if(
       NumArgs==0,   % no exports
       Exports=[],
       (
          M=..[_|ExpDecls],
          ExpDecls=..['.',F,_],
          if(
               is_list(F),       % interface mod([entities])
               ([Tmp]=ExpDecls, Exports=(ibody, e(Tmp))),
               Exports=(ibody, e(ExpDecls))
            )
        )
    ).

readImplAndGenIntrf((module M), _, CurrMod, _, CurrentFile):-
	% no module definitions in modules.
	format(user_error,"\n*** Error: implementation of module '~w' inside \c
	                   module '~w' in file '~w' not allowed.\n",
			   [M,CurrMod,CurrentFile]),
	!,fail.

readImplAndGenIntrf((import F), _, [], [], CurrentFile):-!,
	format(user_error, "\n*** Error: import declaration outside \c
	                    modules not allowed ('~w' imported in file '~w')\n",
	                    [F,CurrentFile]),
	!,fail.

readImplAndGenIntrf((import F), (impRen, Imports,Renamings), CurrentMod, CurrentMod, _):-
  !,
  parseImport((import F), Imports, Renamings).
%  makeListOfTuple(F, LF),
%  listifyArguments(LF, Imports).



% interface body consists not only of import statements; here we 
% are interested in the rest

readImplAndGenIntrf((Line), _, [], [], CurrentFile):-!,
	format(user_error, "\n*** Error: Line '~w' (File ~w) out of any \c
    			    module's scope.\n",
	                    [Line, CurrentFile]),
	!,fail.

% f indicates "function"s
% d indicates "data"
% r indicates "renaming"s
% c indicates constructor. Constructors will be stored in the calling routine,
% findImports/4, in the form c(X), c(Y), ...
% 3rd and 4th comp: Module, original name

%readImplAndGenIntrf((export L), (ibody, e(L2)), M, M, _):-
%  !,
%  if(
%       functor(L,'.',_),
%       L2=L,
%       L2=[L]
%    ).

readImplAndGenIntrf((F::T), (ibody, f(F,T,M,F)), M, M, _):-!.
readImplAndGenIntrf((data D), (ibody, d(D)), M, M, _):-!.
readImplAndGenIntrf((external F::T), (ibody, f(F,T,M,F)), M, M, _):-!.
readImplAndGenIntrf((L if _=_), (ibody, f(Left,dontcare,M,Left)), M, M, _):-
  !,
  functor(L, Left, _).

readImplAndGenIntrf((L if _=_ if _=_), (ibody, f(Left,dontcare,M,Left)), M, M, _):-
  !,
  functor(L, Left, _).
readImplAndGenIntrf((L if _=_ where _), (ibody, f(Left,dontcare,M,Left)), M, M, _):-
  !,
  functor(L, Left, _).
readImplAndGenIntrf((L=_ where _), (ibody, f(Left,dontcare,M,Left)), M, M, _):-
  !,
  functor(L, Left, _).
readImplAndGenIntrf((L=_), (ibody, f(Left,dontcare,M,Left)), M, M, _):-
  !,
  functor(L, Left, _).

%readImplAndGenIntrf((renaming EO in Mod to EN), (ibody,r(EO,EN,Mod)), M, M, _):-!.
readImplAndGenIntrf((infixl(Prio, Name)), (ibody, o(Name, Prio, ixl, M, Name)), M, M, _):-!.
readImplAndGenIntrf((infix(Prio, Name)), (ibody, o(Name, Prio, ix, M, Name)), M, M, _):-!.
readImplAndGenIntrf((infixr(Prio, Name)), (ibody, o(Name, Prio, ixr, M, Name)), M, M, _):-!.
readImplAndGenIntrf(_, [], M, M, _).  %ignore




%:-op(1150,fx,import).
%:-op(1149,xfy, to).
%:-op(1148,xfy,renaming).

k(ImpMod,Renamings):-
  read(L),
  parse(L, ImpMod, Renamings).

parseImport((import _Mod renaming A to B), Imports, Renamings):-
  !,
  makeListOfTuple(_Mod, LF),
  listifyArguments(LF, Imports),
  if(
       LF=[_,_|_],   % list with at least to members
       (write(error1),nl,fail),
       (
	  Imports=[LFM],
	  functor(LFM, Mod, _)
       )
    ),
  !,
  getRenamings(A, B, Mod, [], Renamings).

parseImport((import _Mod), Imports, []):-
  makeListOfTuple(_Mod, LF),
  listifyArguments(LF, Imports),
  functor(_Mod,Mod,_),
  if(
       Mod==to,     %_Mod is a tuple with renamings ==>@!$
       (write(error),nl,fail),
       true
    ).


getRenamings(A, (R renaming K to L), Mod, Accu, Renamings):-
  !,
  getRenamings(K, L, Mod, [r(A,R,Mod)|Accu], Renamings).
getRenamings(A, B, Mod, Accu, [r(A,B,Mod)|Accu]).









%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%%%%%
%%%%%  2.  CRT - I/O
%%%%%
%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Error outputs, odified from Sicstus-Prolog, Bips/msgs.pl .

print_error(syntax_error(_Goal,between(AL,BL),Msg,Tokens,AfterError)) :- !,
        seen,told,
	format(user_error, "{SYNTAX ERROR: in lines ~d-~d}~n", [AL,BL]),
	errdisplay_list([**|Msg]), errdisplay(**), errnl,
	length(Tokens, Length),
	BeforeError is Length-AfterError,
        errdisplay_list(BeforeError, Tokens, Tokens1), errnl,
	errdisplay('** here **'), errnl,
	errdisplay_list(Tokens1), errnl,
        removeTempFiles,
        !,
        fail.
print_error(existence_error(Goal,_ArgNo,ObjType,Culprit,Message)) :- !,
	nonvar(Message),
        seen,told,
	if(
             Message = past_end_of_stream,
	     format(user_error,
	             '{EXISTENCE ERROR: ~q: attempt to read past end of stream}~n',
	             [Goal]),
	     format(user_error,
	             '{EXISTENCE ERROR: ~q ~q does not exist}~n',
		     [ObjType,Culprit])
          ),
          !,
          fail.

print_error(Error) :-
        nonvar(Error),
	format(user_error, '{ERROR: ~q}~n', [Error]),
        seen,told,
        !,
        fail.
print_error(_):-
  	format(user_error, '{GENERAL ERROR.}~n', []),
        seen,told,
        !,
        fail.

errdisplay(T) :- write(T).
errnl :- nl.

errdisplay_list([]).
errdisplay_list([Head|Tail]) :-
	errdisplay_token(Head),
	errdisplay(' '),
	errdisplay_list(Tail).

errdisplay_list(0, S, S) :- !.
errdisplay_list(I, [Head|Tail], S) :-
	errdisplay_token(Head),
	errdisplay(' '),
	J is I-1,
	errdisplay_list(J, Tail, S).

errdisplay_token(atom(X)) :- !, writeq(user_error, X).
errdisplay_token(var(_,X,_)) :- !, errdisplay_string(X).
errdisplay_token(number(X)) :- !, errdisplay(X).
errdisplay_token(string(X)) :- !, errdisplay_str([]), errdisplay_str(X).
errdisplay_token(X-Y) :- !, write(user_error, X-Y).
errdisplay_token(X) :- errdisplay(X).

errdisplay_string([]).
errdisplay_string([X|Xs]) :-
        put(user_error, X),
        errdisplay_string(Xs).

errdisplay_str([]) :- put(user_error, 0'").
errdisplay_str([0'"|Xs]) :- !,
        errdisplay('""'),
        errdisplay_str(Xs).
errdisplay_str([X|Xs]) :-
        put(user_error, X),
        errdisplay_str(Xs).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% printGIL(GIL)
%
% prints the global import table nicely.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

printGIL(GIL):-
  format(user_output, "\n\n++++++++++++++++++\n\c
                           ++ Symbol Table ++\n\c
                           ++++++++++++++++++\n\n",[]),
  \+ \+ (numbervars(GIL,0,_), pG(GIL)).    %\+ \+: no var-bindings

pG([]):-nl.
pG([(File, ModList)|Ls]):-
  format(user_output, "file ~w\n", [File]),
  wrETI(ModList),
  pG(Ls).
wrETI([]):-nl.
wrETI([(Mod, Imps, Exps, Used)|R]):-
  list_to_ord_set(Imps, OI),
  list_to_ord_set(Exps, OE),
  format(user_output, "  + contains module ~w (~w)\n", [Mod, Used]),
  format(user_output, "    - importing ", []),
  printList(OI, 16,16,78),
  format(user_output, "    - exporting ",[]),
  printList(OE, 16, 16, 78),
  wrETI(R).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% printList(L, OldPos, MinPos, MaxPos)
%
% prints the arguments of a list between MinPos and MaxPos. If MaxPos
% is reached, printList proceeds to the next line and restarts
% at MinPos.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

printList([], _, _, _):-!,format(user_output,"\n",[]).
printList(L, Old, Min, Max):-
  pL(L, Old, Min, Max).

pL([], _, _, _).
pL([E|Es], OldPos, MinPos, MaxPos):-
  term2Str(E, [], Str),
  length(Str, L),
  if(
       L+OldPos<MaxPos,
       (
	  format(user_output,"~w",[E]),
	  NPos is OldPos+L
       ),
       (
	  mkMinPos(0, MinPos, [], Spaces),
	  name(X, Spaces),
	  format(user_output, "\n~w~w", [X, E]),
	  NPos is MinPos+L
       )
    ),
  if(Es=[],
     (format(user_output, "\n",[]), NP2 is NPos),
     (format(user_output, ", ", []), NP2 is NPos+2)
    ),
  pL(Es, NP2, MinPos, MaxPos).
	  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% args2Str/3, term2Str/3
%
% converts a term into a list of its characters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

args2Str([],A,A).
args2Str([A|As], Old, New):-
  term2Str(A, [], ANew),
  ownappend(Old, ANew, New2),
  if(As=[], New3=New2, ownappend(New2, [44],New3)),
  args2Str(As, New3, New).

term2Str(Term, OldStr, NewStr):-
  if(
       nonvar(Term),
       (Term =..[Top|Args]),
       (Top='vvv',Args=[])   % vars are of the form A??
    ),
  name(Top, Ascii),
  ownappend(OldStr, Ascii, O2),
  if(Args=[], O3=O2, ownappend(O2, [40], O3)),   % '('
  args2Str(Args, [], ArgsStr),
  ownappend(O3, ArgsStr, O4),                    % ','
  if(Args=[], NewStr=O4, ownappend(O4, [41], NewStr)).  % ')'



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% mkMinPos(ActPos, MinPos, RAccu, Result)
%
% builds a list of MinPos Spaces.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
mkMinPos(MinPos, MinPos, R, R):-!.
mkMinPos(ActPos, MinPos, Result, NR):-
  ownappend([32], Result, NewRes),
  NewPos is ActPos+1,
  mkMinPos(NewPos, MinPos, NewRes, NR).



