%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CHANGES since July 98:
%
%%%%%
% 8.12.98 - Frank Steiner
%
% - changed 'ite' into '$ite'. Became neccessary due to a change in
%   the parser
% - for the transformation of rules with several guards:
%   - rules of store-predicate changed
%   - makeCondList predicate added
%   - transformCond predicate added
% 
%%%%%
% 8.1.99 - Frank Steiner
%
% for enabling the new choice annotation:
% transformExpr(choice Args), transformChoiceArgs, decideOnCondition removed

% TODO:
% - wenn prelude explizit importiert wird, gibt's Aerger
%



:- dynamic constructor/4, function/3, typen/2, rule/2, currline/1,
           functionTreeFlag/2,treeStrategy/1,temptype/3,temprule/2,
           isExternal/1, root_module/1, noInterface/1, modExportsMod/2, 
           prelpath/1, preldefs/1, entityNotVariable/1, lineToBeStored/2,
           actualConstructors/1, preludeDataDef/1, symbtab/1, rootsymbtab/1,
	   actualRootConstructors/1, generalError/0.

:-use_module(maketree).
:-use_module(typecheck).
:-use_module(library(system)).
%% keine doppelten Modulimplementationen. Dann gibts Probleme!!
%% bei Importberechnung

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                            %%%%%
%%%%%                                                            %%%%%
%%%%%   Module: modsys.pl					 %%%%%
%%%%%								 %%%%%
%%%%%								 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% has to be done before the operators' declarations.

% do it before anything else is done!
:-use_module(reservedNames).
:-use_module(operators).

% is undone at the end of this file ...
:- op(885,xfy,(;)).



:-use_module(io).
:-use_module(ownlists).
:-use_module(filesystem).
%:-use_module(lists).
:-use_module(library(ordsets)).


readAll(File, NewTT, ResultGIL, AllKnownNames):-
  op(848, xfy, (->)),
  %okay - in this case we may read the prelude twice ...
  retractall(preldefs(_)),
  readHeaders(prelude, PGILTmp, [], _, ''),   
  % delete constructors that are not really constructors, but
  % variables. This can be done that easily only for the prelude
  % as it is sure that the prelude does not import anything.
  PGILTmp=[(_,[(_,_,PrExpos,_)])],
  extractActualConstructors(PrExpos, PrExpos, [], ActualPrelConsts),
  modifyPreludesTable(PrExpos, ActualPrelConsts, [], NewPrExpos),!,
  asserta(preldefs([(prelude,[(prelude,[],NewPrExpos,used)])])),
  prepareFiles(File, ROOTMod),!,
  name(ROOTMod, AsciiMod),
  asserta(root_module(AsciiMod)),
%  write('Pass 1:'),nl, flush_output,

  write('reading interfaces ...'),nl,flush_output,
  pass1(GIL, _, Checked, PreludesExp, ROOTMod),
  makeInterfFileList(GIL, CheckedFiles),!,
  removeOperators(PreludesExp, [], PrelExp),
  %write('Pass 2:'), nl, flush_output,
  nl,write('reading implementations ...'),nl,flush_output,
    % 4th par: new symbol table; maybe for debugging purposes
%  printGIL(GIL),nl,
  pass2(Checked, [], EntityList, GIL, ResultGIL, Checked, NewChecked, CheckedFiles, _, KnownNames, PreludesExp),
%  printGIL(GIL),nl,nl,
  ownappend([prelude], NewChecked, NC),
  ownappend([(prelude, PrelExp)], KnownNames, KNs),
  %printGIL(ResultGIL),
  write('storing implementations ...'),nl,flush_output,
  if(retractall(globalTable(_)),true,true),
  asserta(globalTable(ResultGIL)),
  readImplementations(NC, KNs, EntityList, [], ROOTMod),!,
  retractall(globalTable(_)),

  buildTranslationTable(KNs, ROOTMod, TrTable, ROOTMod),
  % renamed but not exported entities at top level are not visible

  %modifyTrTable(TrTable, ResultGIL, ROOTMod, NewTT),
  NewTT=TrTable,
  AllKnownNames=KNs,
  if(
       rootsymbtab(RST),
       (
	  retractall(rootsymbtab(_)),
	  modifyTrTable(RST, ResultGIL, ROOTMod, NewRST),
	  asserta(rootsymbtab(NewRST))
       ),
       true
    ).
%modifyTrTable(TT,_,_,TT).

% rausnehmen, was in der TrTable steht, aber nicht von diesem Modul
% exportiert wird.
modifyTrTable(TT, GIL, ROOTMod, Result):-
  append(_, [(_,ModL)|_], GIL),
  append(_, [(ROOTMod, _, E, _)|_], ModL),
  !,
  modifyTT(TT, E, [], Result).

modifyTT([], _, L, L).
modifyTT([(Name, Renamed)|Rest], Exports, Accu, NewKNs):-
  ((member(d(D1=_,_,_), Exports), functor(D1, Name, _))
   ;(member(d(D2,_,_),Exports), functor(D2, Name, _))
   ;(member(c(C,_,_), Exports), functor(C,Name,_))
   ;(member(f(F,_,_,_,_,_), Exports), functor(F,Name,_))
  ),
  % entity actually is exported
  !,
  modifyTT(Rest, Exports, [(Name,Renamed)|Accu], NewKNs).

modifyTT([_|Rest], Exports, Accu, NewKNs):-
  modifyTT(Rest, Exports, Accu, NewKNs).

checkAgainDoubleEntities(TrTable, Mod):-
  findall(N1, 
	  (member((N1,NN1), TrTable),
           member((N1,NN2), TrTable),
           NN1\==NN2
          ),
          _ListOfDoubles
         ),
  remove_duplicates(_ListOfDoubles, ListOfDoubles),
  ListOfDoubles\==[],
  format(user_output,
         "\n*** Error:  In module ~w, the following entities are\n    \c
           defined more than once:\n    ~w\n",
          [Mod, ListOfDoubles]),
  asserta(generalError).


  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% curryList(Eqs, Accu, Result)
%
% curryfies all equations in Eqs and stores the result in Result.
% The equations have to be in applied form, i.e. g@A@2 rather
% than g(A,2).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

curryList([],L,L).
curryList([E|Es], Accu, Result):-
%  write('currying '), write(E),
  curryEquation(E, ECurried),
%  write(' to '), write(ECurried),nl,flush_output,
  ownappend(Accu, [c(ECurried,dummy,dummy)], Tmp),
  curryList(Es, Tmp, Result).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% curryEquation(A=R, ResultL=ResultR)
%
% curryfies A=R into ResultL=ResultR. A has to be in applied form
% i.e. g@A@2 rather than g(A,2).
% Partial functions will be simulated by choice constructs, i.e.
% g@A@2=A will be transformed into
% g= \A-> \_A->choice ({_A==2=true}->A)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

curryEquation((A = R), (Top = (Result))):-
  getAppliedArgs(A, [], [Top|Args]),
%  write('##'), write(Args),nl,
  ownappend(Args, [R], Args2),
  curryArgs(Args2, [], _, Result).
%  makeApplyList(Args, B, Result).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeCondList(VarValuePairs, AccuChoices, ResultChoices)
%
% transforms the (Var, Value) pairs in the first argument into
% a term Var_1==Value_1 && ... && Var_n==Value_n
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeCondList([], L, L).
makeCondList([(Var, Value)|Rest], Choices, ResultChoices):-
  if(
       nonvar(Value),
       (
	  NewConj=..[==, Var, Value],
          if(
	       var(Choices),
               NewChoices=NewConj,
               NewChoices=..[&&, Choices, NewConj]
            )
       ),
       NewChoices=Choices
    ),
  makeCondList(Rest, NewChoices, ResultChoices).

curryArgs([A|[]], Accu, Pars, B):-
  !,
  makeCondList(Accu, _, Choices),
  if(
       nonvar(Choices),
       (
	  NewC1=..[=, Choices, true],
	  NewC2=..[(->), {NewC1}, A],
	  B=..[choice, NewC2]
       ),
       B=A
    ),
  bindLambdas(Accu).

curryArgs([A|As], AccuPar, Pars, Res):-
  var(L),
  NewAccu=[(L,A)|AccuPar],
  curryArgs(As, NewAccu, Pars, Tmp),
  Res1=..[(->), L, Tmp],
  Res=..[\,Res1].

bindLambdas([]).
bindLambdas([(L,R)|Rest]):-
  if(
       var(R),
       (L=R, bindLambdas(Rest)),
       bindLambdas(Rest)
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% getAppliedArgs(AppliedTerm, Accu, Args)
%
% if AppliedTerm is of the form A1@A2@A3... then Args will
% be [A1,A2,A3,...].
% If there is no '@' in the input term, then this term is returned
% as the only argument.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
getAppliedArgs(K, Accu, [K|Accu]):-
  var(K),
  !.
getAppliedArgs(K, Accu, L):-
  K=A@B,
  !,
  NewB=B,
  getAppliedArgs(A, [NewB|Accu], L).
getAppliedArgs(K, Accu, [K|Accu]).  









% SmallVars: Variables with small letters!
makeSmallVarsNames([], L, L).
makeSmallVarsNames([(Name,Var)|Rest], Accu, Result):-
  makeSmallVarsNames(Rest, [(Name=Var)|Accu], Result).

extraOrLambda(Term, VarNamesInTerm, SmallVars):-
  makeVarList(Term, VarsInTerm),
  notExtraOrLambda(Term, NotExtra),
  makeSmallVarsNames(SmallVars, [], SmallVarsNames),
  ownappend(SmallVarsNames, VarNamesInTerm, AllVarsNames),
  if(
       NotExtra == ignore,
       true,
       (
	  list_to_ord_set(NotExtra, NEx_Ord),
	  list_to_ord_set(VarsInTerm, VIT_Ord),
	  ord_subtract(VIT_Ord, NEx_Ord, ExtraVars),
	  warnExtraVars(ExtraVars, AllVarsNames, Term, SmallVars)
       )
    ).


warnExtraVars([], _, _, _).
warnExtraVars([V|Vs], Names, Term, SmallVars):-
  %wEV(Names, V, Term, Names, SmallVars),  % MH: remove ev warnings
  warnExtraVars(Vs, Names, Term, SmallVars).


wEV([], _, _, _, _).
wEV([(Name=Var)|_], V, Term, VarNames, SmallVars):-
  Var==V,  % !!! both uninstantiated !!!
  \+ name(Name, [95|_]),
  \+ \+ (
	   bindVariables(Term, VarNames, TermString, SmallVars),
           format(user_output, 
                  "+++ Warning: in line ~w,\n    '~w' is \c
                  an extra variable not starting with '_'.\n",
                  [TermString, Name]
                 )
        ),
  !.

wEV([_|Vs], V, Term, VarNames, SmallVars):-
  wEV(Vs, V, Term, VarNames, SmallVars).


bindVariables(Term, VarNames, Result, SmallVars):-
  if(
       var(Term),
       getVarName(VarNames, Term, Result, SmallVars),
       (
	  Term=..[F|Args],
          bindVarArgs(Args, VarNames, [], BoundArgs, SmallVars),
          Result=..[F|BoundArgs]
       )
    ).

bindVarArgs([], _, L, L, _).
bindVarArgs([A|Args], VarNames, Accu, BoundArgs, SmallVars):-
  bindVariables(A, VarNames, ABound, SmallVars),
  ownappend(Accu, [ABound], Tmp),
  bindVarArgs(Args, VarNames, Tmp, BoundArgs, SmallVars).

getSmallVarNameReverse([], L, L).
getSmallVarNameReverse([(String,Var)|Rest], V, NewName):-
  if(
       String==V,
       NewName=Var,
       getSmallVarNameReverse(Rest, V, NewName)
    ).
  
% anonymous vars.
getSmallVarName([], _, '_').

getSmallVarName([(String,Var)|Rest], V, NewName):-
  if(
       Var==V,
       NewName=String,
       getSmallVarName(Rest, V, NewName)
    ).

getVarName([], V, NewName, SmallVars):-
  getSmallVarName(SmallVars, V, NewName).

getVarName([(Name=Var)|Vs], V, NewName, SmallVars):-
  if(
       Var==V,
       NewName=Name,
       getVarName(Vs, V, NewName, SmallVars)
    ).


extractLambdas(A, _, []):-
  var(A),
  !.
extractLambdas((A;B), _, Result):-
  !,
  notExtraOrLambda(A, Vars1),
  notExtraOrLambda(B, Vars2),
  ownappend(Vars1, Vars2, Result).

extractLambdas((A,B), _, Result):-
  !,
  notExtraOrLambda(A, Vars1),
  notExtraOrLambda(B, Vars2),
  ownappend(Vars1, Vars2, Result).

extractLambdas(\ (A->B), _, Result):-
  !,
  if(
       var(B),
       Tmp=[],
       notExtraOrLambda(B, Tmp)
    ),
  ownappend(Tmp, [A], Result).

% lambda-funcs as arguments
extractLambdas(F, _, Result):-
  F=..[_|Rest],
  extractLambdaList(Rest, [], Result).

extractLambdas(_, L, L).

extractLambdaList([], L, L).
extractLambdaList([L|Ls], Accu, Result):-
  extractLambdas(L,_,R1),
  ownappend(R1, Accu, NewAccu),
  extractLambdaList(Ls, NewAccu, R2),
  ownappend(R1,R2,Result).


notExtraOrLambdaList([], L, L).
notExtraOrLambdaList([A|As], Accu, Vars):-
  notExtraOrLambda(A, VarsInA),
  ownappend(VarsInA, Accu, NewAccu),
  notExtraOrLambdaList(As, NewAccu, Vars).
notExtraOrLambdaInWhere(LSorted, LocPats, Vars):-
  if(
	LSorted \== empty, 
	ownappend([LSorted], LocPats, NewLP),
	NewLP=LocPats
    ),
  notExtraOrLambdaList(NewLP, [], Vars).


notExtraOrLambda(L, [L]):-var(L), !.

notExtraOrLambda((external _::_), ignore):-!.
notExtraOrLambda((_::_), ignore):-!.
notExtraOrLambda((data(_)),ignore):-!.

notExtraOrLambda((A,B), Vars):-
  !,
  notExtraOrLambda(A, Vars1),
  notExtraOrLambda(B, Vars2),
  ownappend(Vars1, Vars2, Vars).

notExtraOrLambda((A;B), Vars):-
  notExtraOrLambda(A, Vars1),
  notExtraOrLambda(B, Vars2),
  ownappend(Vars1, Vars2, Vars).

notExtraOrLambda((A >> B), Result):-
  !,
  notExtraOrLambda(A, Vars1),
  notExtraOrLambda(B, Vars2),
  ownappend(Vars1, Vars2, Result).

notExtraOrLambda((A >>= B), Result):-
  !,
  notExtraOrLambda(A, Vars1),
  notExtraOrLambda(B, Vars2),
  ownappend(Vars1, Vars2, Result).

notExtraOrLambda(\ (A->B), Vars):-
  !,
  extractLambdas(\ (A->B), [], Vars).
  
notExtraOrLambda((L=R), Vars):-
  var(L),
  !,
  extractLambdas(R,[],Vars2),
  ownappend([L], Vars2, Vars).


notExtraOrLambda((L if _=R), Vars):-
  var(R),
  !,
%write('1aaa '),write(L),nl,
  makeVarList(L, Vars).
notExtraOrLambda((L if _=_ if _=_), Vars):-
  !,
%  notExtraOrLambda((L if C=R), Vars1),
%  notExtraOrLambda((L if C1=MoreClauses), Vars).
%write('2aaa '),write(L),nl.
  makeVarList(L, Vars).
notExtraOrLambda((L if _=_), Vars):-
  !,
%write('3aaa '),write(L),nl,
  makeVarList(L, Vars).
notExtraOrLambda((L if _=R where LL), Vars):-
  var(R),
  !,
  makeVarList(L, Vars1),
  sortWheres(LL, LLSorted, LLPats),
  notExtraOrLambdaInWhere(LLSorted, LLPats, Vars2),
  ownappend(Vars1, Vars2, Vars).
notExtraOrLambda((L if _=_ if _=_ where LL), Vars):-
  !,
  makeVarList(L, Vars1),
  sortWheres(LL, LLSorted, LLPats),
  notExtraOrLambdaInWhere(LLSorted, LLPats, Vars2),
  ownappend(Vars1, Vars2, Vars).
notExtraOrLambda((L if _=_ where LL), Vars):-
  !,
  makeVarList(L, Vars1),
  sortWheres(LL, LLSorted, LLPats),
  notExtraOrLambdaInWhere(LLSorted, LLPats, Vars2),
  ownappend(Vars1, Vars2, Vars).

notExtraOrLambda((L=R where LL), Vars):-
  !,
  makeVarList(L, Vars1),
  sortWheres(LL, LLSorted, LLPats),
  notExtraOrLambdaInWhere(LLSorted, LLPats, Vars2),
  if(
       var(R),
       Vars3=[],
       extractLambdas(R, [], Vars3)
    ),
  ownappend(Vars1, Vars2, Tmp),
  ownappend(Tmp, Vars3, Vars).

notExtraOrLambda(L=R, Vars):-
  !,
  if(
       var(R),
       Vars2=[],
       extractLambdas(R, [], Vars2)
    ),
  makeVarList(L, Vars3),
  ownappend(Vars2, Vars3, Vars).

notExtraOrLambda((if _ then B else C), Vars):-
  !,
  notExtraOrLambda(B, Vars1),
  notExtraOrLambda(C, Vars2),
  ownappend(Vars1, Vars2, Vars).

notExtraOrLambda(_,[]).

% /2
%makeVarList(T,TT):-term_variables(T,TT).
makeVarList(T, [T]):-var(T),!.
makeVarList(Term, Result):-
  nonvar(Term),
  Term=..[_|Args],
  makeVarList(Args, [], Result).

% /3
makeVarList([], L, L2):-remove_duplicates(L,L2).
makeVarList([Arg|Args], Accu, New):-
  makeVarList(Arg, AL1),
  ownappend(AL1, Accu, Tmp),
  makeVarList(Args, Tmp, New).




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeGlobalTypeList, globalType
%
% allow the acces to a list of global constructors and data types.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% '.' for lists; ',' for tuples
makeGlobalTypeList([constraint,int,float,filename,'.',[],{},',',dontcare]).
globalType(X):-
  makeGlobalTypeList(L),
  ownmember(X,L).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% readImplementations(Modules, KnownNames, EntityList, CheckedModules, ROOTMod)
%
% reads the implementations and possibly renames the terms.
% Modules is a list of the modules to be read, KnownNames is the 
% resulting list of all known entities in a specific modules,
% EntityList contains information about operator decls. and renamings
% in implementations, and a list of the checked modules has to be
% passed to this predicate in CheckedModules. The code is stored
% so that Curry can work on it. ROOTMod is needed for building the 
% translation table.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

readImplementations([], _, _, _, _).
readImplementations([M|Ms], KnownNames, EntityList, CheckedModules, ROOTMod):-
  if(
       member(M, CheckedModules),
       NewCheckedModules=CheckedModules,
       (
	  if(
	       M==prelude,
	       prelpath(File),
	       implementationInFile(M, File)
	    ),
	  addExtension(File, '.fl', ImplFile),
          on_exception(ErrorMsg,
	               see(ImplFile),
		       (print_error(ErrorMsg),fail)
                      ),
          format(user_output, "processing module ~w ...\n", [M]),
	  rI(M, KnownNames, EntityList, [], File, CheckedModules, NewCheckedModules, ROOTMod)
       )
    ),
  readImplementations(Ms, KnownNames, EntityList, NewCheckedModules, ROOTMod).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% rI/8
%
% cf. readImplementations/5. rI/8 does it for one module.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

rI(M, KnownNames, EntityList, TrTable, File, OldCheckedModules, NewCheckedModules, ROOTMod):-
  on_exception(ErrorMsg,
	       read_term(Line,[variable_names(VarNames)]),
			( %should have been recognized before !
			  format(user_error,
				 "\n*** In file \c
				  '~w', module '~w':\n",
				  [File, M]),flush_output,
                                  seen,
			   !,
			   print_error(ErrorMsg),
			   fail
                        )
		      ),
  readImplementation2(Line, Return),
  if(
       Return=no,
       (
	  NewMod=M,
	  NewTrTable=TrTable,
	  TmpCheckedModules=OldCheckedModules
       ),
       if(
            Return=(newMod, NewMod), 
            (
               ownappend(OldCheckedModules, [NewMod], TmpCheckedModules),
	       buildTranslationTable(KnownNames, NewMod, NewTrTable, ROOTMod),
	       declareImplOperators(NewMod, EntityList)
	    ),
	    (
	       %renF(Return, TrTable, LineRenamed, M, ROOTMod, prefixIt),
       	       %renF(Return, TrTable, LineRenamedNoPrefix, M, ROOTMod, dontprefixIt),
               % collect Constructors and functions
               readImplAndGenIntrf(Return, Parsed, dummy, dummy,_),
               if(
                    Parsed=(ibody,Parsed2),
                    if(
                         Parsed2=f(EE1,_,_,_),
                         (
                             assertz(entityNotVariable(EE1))
                         ),
                         if(
                              Parsed2=d(EE2),
                              if(
                                   EE2=(EE21=EE22),
                                   (
                                       if(
                                             M==prelude,
                                             (
                                                assertz(preludeDataDef(d(EE2,prelude,EE2))),
                                                makeConstructorList(EE22,[],PrelCList),
                                                remove_duplicates(PrelCList, PCL2),
                                                addConstsOrigin(PCL2, prelude, [], PCL3),
                                                assertz(preludeDataDef(PCL3)),
                                                assertz(preludeDataDef(d(EE2,prelude,EE2)))
                                             ),
                                             true
                                         ),
                                       makeTopLevelConstructorList(EE22, [], EE22List),
                                       assertz(entityNotVariable(EE22List)),
                                       functor(EE21, EE21F, _),
                                       assertz(entityNotVariable(c(EE21F)))
                                   ),
                                   (
                                       functor(EE2, EE23, _),
                                       assertz(entityNotVariable(EE23))
                                   )
                                ),
                                true  
                           )
                      ),
                      true
                 ),
   
	       NewMod=M,
	       NewTrTable=TrTable,
	       TmpCheckedModules=OldCheckedModules,
	       %format(user_output, "Line ~w: ~w\n", [M,Line]),
               assertz(lineToBeStored(Return, VarNames))
	    )
	 )
    ),
  if(
       Line==end_of_file,
       (
           findall(ENV,entityNotVariable(ENV),NotVars),
           ownflatten(NotVars,NV2),
           remove_duplicates(NV2,NV3),
           map(delC,NV3,[],NV4),
%           write('found entities   '),
%           write(NV4),nl,
           if(
                M==prelude,
                (
                    % we don't have a GIL for the prelude, so we have
                    % to build it now. We only need data types and
                    % constructors for the moment, so it's easy.
                    findall(PrelData, preludeDataDef(PrelData),PrelDats),
                    ownflatten(PrelDats, PrelDatsFlat),
                    remove_duplicates(PrelDatsFlat,PDF2),
                    asserta(globalTable([(prelude,[(prelude,[],PDF2,used)])])),
                    retractall(preludeDataDef(_))
                ),
                true
             ),
           extractActualConstructors(M, NewTrTable, NewTr2),
%           write(NewTr2),

           globalTable(GT),
           append(_, [(_,ModList)|_], GT),
           append(_, [(M,_,ExpsOfM,_)|_], ModList),
           !,
           storeProgram(M,NV4,NewTr2,ROOTMod,[], ExpsOfM),
           if(
                M==prelude,
                (retract(globalTable(_)),!),
                true
             ),
           if(retractall(entityNotVariable(_)),true,true),
           seen,  

           NewCheckedModules=OldCheckedModules, 
           !,
           if(M==ROOTMod,
              (retractall(rootsymbtab(_)),asserta(rootsymbtab(NewTr2))),
              true
             )
       ),
       rI(NewMod, KnownNames, EntityList, NewTrTable, File, TmpCheckedModules, NewCheckedModules, ROOTMod)
    ).

checkIfJustOnce(_, _, prelude):-
  !.
checkIfJustOnce(Entity, TrTable, Module):-
  write('checking '),write(Entity),nl,
  member((Entity,_), TrTable),
  !,
  format(user_output,
         "\n*** Error:  In module ~w, ~w is defined more than once.\n",
          [Module, Entity]),
  flush_output,
  asserta(generalError).
checkIfJustOnce(_, _, _).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% getTops(List, Accu, REsult)
%
% returns a list of the top symbols in List that are no globalTypes
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

getTops([],L,L).
getTops([A|As], Accu, Result):-
  var(A),
  !,
  getTops(As, Accu, Result).
getTops([A|As], Accu, Result):-
  functor(A,F,Arity),
  if(Arity==0,
     getTops(As, Accu, Result),
     (if(globalType(F), getTops(As, Accu, Result), getTops(As, [F|Accu], Result)))
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% deleteDataTypes(ConstList, ModsExports, Accu, Result)
%
% ConstList is a list of constructors or data types (all subterms
% of a RHS of a data decl) of the form c(..),
% ModExports is what the module exports.
% This predicate returns a list of all constructors in ConstList
% that actually are constructors and not data types.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

deleteDataTypes([], _, L, L).
deleteDataTypes([c(C)|Rest], Entities, Accu, Result):-
  if(
       (
          (member(d(A=_,_,_),Entities)
           ;member(d(A,_,_),Entities)
          ),
          functor(A,C,_)
       ),
       (!, deleteDataTypes(Rest, Entities, Accu, Result)),
       (!, deleteDataTypes(Rest, Entities, [C|Accu], Result))
    ).

          

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% storeProgram(Module, NotVars,TrTable,ROOTMod,RHSConsts,ExpsOfM)
%
% stores the code of module Module. The code lines are stored by the
% dynamic predicate lineToBeStored/2.
% NotVars contains a list of entities which are certainly no vars,
% TrTable is the TranslationTable, ROOTMod the root module.
% RHSConsts are the RHS constructors in this module, needed for
% the detection of illegal multiple constructor usages
% ExpsOfM are Module's exports, neede for detection of illegal
% constructor detection and detection of datatypes on RHS
% that are not encapsulated.
%
% store/1 cannot be executed immediately because variables have
% to be detected first.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

storeProgram(Module, NotVars,TrTable,ROOTMod,RHSConsts,ExpsOfM):-
  if(
       lineToBeStored(L, VarNamesInL),
       (
          retract(lineToBeStored(L,VarNamesInL)),
          !,  %just one!

  
          % get variables of where-locals
	  if(	
	       L=(_ where _Locals),
	       (
	          sortWheres(_Locals,_LS, _LP),
	          if(
		       _LS \== empty, 
		       ownappend([_LS], _LP, _NLP),
		       _NLP=_LP
		    ),
		  map(addCdummy, _NLP, [], _NNLP),
		  makeSemicolList(_NNLP, _NLPSemi),
		  getBothSides(_NLPSemi, [], [], _LINKS, _),
		  getTops(_LINKS, [], _TopLINKS),
		  ownappend(_TopLINKS, NotVars, _NewNotVars),
		  remove_duplicates(_NewNotVars, _NewNotVars2)
	       ),
	       _NewNotVars2=NotVars
	    ),    

          renTermDetVars(L, TrTable, NewL, Module, ROOTMod, _NewNotVars2, [], SmallVars),
          if(
               L=(data LEFT=RIGHT),
               (
                  %check if there are datatypes on RHS data decls which are
                  %not encapsulated
                  functor(LEFT, LEFTF, _),
                  makeTopLevelConstructorList(RIGHT, [], RightConsts),
                  remove_duplicates(RightConsts, NewRightConsts),
                  findall(K,
                          (member(c(K),NewRightConsts),
                           (member(d(A=_,_,_), ExpsOfM)
                            ;member(d(A,_,_), ExpsOfM)
                           ),
                           functor(A, K, _),
                           K\==LEFTF           %e.g. data unit=unit
                          ),
                          NotEncapsulated
                         ),
                   remove_duplicates(NotEncapsulated, NotEnc),
                   if(NotEnc==[],
                      true,
                      (
                          format(user_error, 
                                 "+++ Warning:  In module ~w,\n    line  ~w\n    \c
                                  (originally ~w)\n    \c
                                  there are \c
                                  not encapsulated data type(s) \n    ~w \c
                                  at RHS of data declaration.\n",
                                 [Module, NewL, L, NotEnc]
                                )
                      )
                     )
               ),      
               NewRHSConsts=RHSConsts
          ),   %if L=data _=_
          retractall(currline(_)),
          assertz(currline(NewL)),
%write('##0'),write(NewL),nl,
          store(NewL),
%write('##1 '),write(NewL),nl,
          extraOrLambda(NewL,VarNamesInL, SmallVars),
%write('##2 '),write(NewL),nl,write(SmallVars),nl,
safi(checkThis(NewL, L, Module)),
          storeProgram(Module, NotVars,TrTable,ROOTMod, NewRHSConsts, ExpsOfM)
       ),
       true
    ).




                   %check if there is an illegal usage of constructors
                   % 1)  double decl in this module
%                   makeConstructorList(RIGHT, [], _RC2),
%                   remove_duplicates(_RC2, RC2),
% gehtsoeinfachnicht !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
% weil die Datentypen nicht im Exportteil stehen muessen!
%                   deleteDataTypes(RC2, ExpsOfM, [], NewRC2),
%                   append(RHSConsts, NewRC2, NewRHSConsts),
%                   list_to_ord_set(RHSConsts, _RHSConsts),
%                   list_to_ord_set(NewRC2,_NewRC2),
%                   ord_intersection(_NewRC2, _RHSConsts, _UsedTwice),
                   % small vars have not been ignored yet
%                   removeSmallVars(_UsedTwice, SmallVars, [], UsedTwice),
%                   if(UsedTwice==[],
%                      true,
%                      (
%                          asserta(generalError),
%                          format(user_error, 
%                                 "*** Error:  In module ~w,\n    line  ~w\n    \c
%                                  (originally ~w)\n    \c
%                                  there are \c
%                                  illegal multiple usages of constructor(s) \n    ~w.\n",
%                                 [Module, NewL, L, UsedTwice]
%                                )

%                      )
%                     ),

                   % 2) double decl in another module
%write('--'),nl,
%write(NewRC2),nl,
%write(TrTable),nl,write('++'),nl,nl,
%findall(K, (member(K, NewRC2), member((K,_), TrTable)), ListOfK),
%                   if(
%                        Module\==prelude,
%                        (
%                            if(
%                                  (member((LEFTF,_),TrTable)
%                                   ;ListOfK\==[]
%                                  ),
%true,
%                                  (write('SHIT'), write(LEFTF),nl,write(ListOfK),nl,nl),
%                                  true
%                              )









safi(A):-call(A),!.
safi(_).

checkThis(NewL, L, Module):-
  readImplAndGenIntrf(NewL, P1, dummy, dummy,_),
  readImplAndGenIntrf(L, P2, dummy,dummy,_),
  if(P1=(ibody, Parsed),
     P2=(ibody, Parsed2),
     fail),
  if(Module\==prelude,
(
  name(Module, ModAscii),
  ownappend(ModAscii, [95], MA),
  checkThis2(Parsed, Parsed2, MA)
),true).

checkThis2(P1, P2,MA):-
  P1=f(A,_,_,_),
  !,
  P2=f(A2,_,_,_),
  name(A,Aascii),
  if(
       append(MA, _, Aascii),
       true,
       (
	  functor(A2, Out, _),
	  append(MA2,[95],MA),
          !,
	  name(M, MA2),
          format(user_error, 
                 "\n*** Error:  In module ~w,\n    function '~w' \c
                  is redefined.\n",
                  [M, Out]),
	  asserta(generalError)
       )
    ).
checkThis2(P1, P2,MA):-
  P1=d(L=_),
  !,
  P2=d(L2=_),
  functor(L, LF, _),
  name(LF,LFascii),
  if(
       append(MA, _, LFascii),
       true,
       (
	  functor(L2, Out, _),
          append(MA2,[95],MA),
          !,
          name(M,MA2),
          format(user_error, 
                 "\n*** Error:  In module ~w,\n    data type '~w' \c
                  is redefined.\n",
                  [M, Out]),
          asserta(generalError)
       )
    ).
checkThis2(_,_,_).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeSmallVars(List, SmallVars, Accu, Result)
%
% removes all small vars form List and stores  the result in Result.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeSmallVars([], _, L, L).
removeSmallVars([A|Rest], SmallVars, Accu, Result):-
  if(\+ \+ member((A,_), SmallVars),
     removeSmallVars(Rest, SmallVars, Accu, Result),
     removeSmallVars(Rest, SmallVars, [A|Accu], Result)
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% getBothSides(SemicolList, AccuL, AccuR, LHS, RHS)
% 
% SemicolList is a where declaration. Because of the op precedences
% we have to identify left and right hand sides in terms of
% the form L1=R1;L2=R2; ... which is parsed by prolog
% as L1=(R1;L2=(R2; ...))
%
% LHS and RHS are the results.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

getBothSides((A;B), AccuLeft, AccuRight, LHS, RHS):-
  !,
  A=(L=R),
  ownappend([L], AccuLeft, LHSTmp),
  ownappend([R], AccuRight, RHSTmp),
  getBothSides(B, LHSTmp, RHSTmp, LHS, RHS).
getBothSides((L=R), AL, AR, AL1, AR1):-
  ownappend([L], AL, AL1),
  ownappend([R], AR, AR1).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% merg(LHS, RHS, Result)
%
% merges the results of getBothSides/5 into [(L1=R1);(L2=R2); ...
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

merg(LHS, RHS, Result):-
  if(
       length(LHS,1), 
       (
           [L]=LHS,
           [R]=RHS,
           Result=..[=,L,R]
       ),
       (
           LHS=[FirstL|RestL],
           merg2(RHS, RestL,  NewR),
           Result=..[=,FirstL,NewR]
       )
    ).

merg2([L|Ls], [R|Rs], Result):-
  New=..[(;),L,R],
  merg2(Ls,Rs, Rest),
  Result=(New=Rest).
merg2([A],[],A).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% clearTrTable(RenamingList, TrTable, Exports, ActConsts, NewTrTable)
%
% checks if in TrTable there are constructors that actually are
% variables and removes them (a small 'a' in data ...=...;list(a);...
% could be both a variable or a constructor.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clearTrTable([], TrTable, _, _, TrTable).
clearTrTable([(N,NRen)|Rest], Accu, Exports, ActConsts, NewTrTable):-
  if(
       member(c(N,_,_), Exports), 
       if(
            member(c(N), ActConsts),
            clearTrTable(Rest, [(N,NRen)|Accu], Exports, ActConsts, NewTrTable),
            % in this case a variable was supposed to be a constructor
            clearTrTable(Rest, Accu, Exports, ActConsts, NewTrTable)
         ),
       clearTrTable(Rest, [(N,NRen)|Accu], Exports, ActConsts, NewTrTable)
    ).      



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extractActualConstructors(Module, OldTrTable, NewTrTable)
%
% stores in the dynamic predicate actualConstructors/1 a list
% of the actual constructors, i.e. constructors that are not
% variables (in the beginning of the reading, we were not able
% to distinguish them!). The NewTrTable is the OldTranslationTable
% without the variables-constructors.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% /3
extractActualConstructors(Module, OldTrTable, NewTrTable):-

  globalTable(GT),
  member((_,ModList), GT),
  member((Module, _, Exports, _), ModList),
  !,
  extractActualConstructors(Exports, Exports, [], ActConsts),
  if(retractall(actualConstructors(_)), true, true),
  asserta(actualConstructors(ActConsts)),
  if(
       root_module(RMAscii),
       (
	  name(RM, RMAscii),
	  if(
	        RM==Module,
	        (
		   retractall(actualRootConstructors(_)),
		   asserta(actualRootConstructors(ActConsts))
     		),
	        true
	    )
       ),
       true
    ),
  clearTrTable(OldTrTable, [], Exports, ActConsts, NewTrTable).
  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extractActualConstructors/4
%
% cf. /3. Exports is the export list of a module.
% It is necessary to be able to look for imported
% constructors (unary).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% /4
extractActualConstructors([],_,Old,Old).
extractActualConstructors([d(_=DTCs,_,_)|Rest], Exports, Old, New):-
  !,
  makeUnaryConstructorList(DTCs, Exports, [], UCL),
  getSubtermsWithoutBottom(DTCs, DTCSubs),
  map(addC, DTCSubs, [], DTCSubs2),
  append(Old, UCL, Tmp),
  append(Tmp, DTCSubs2, Tmp2),
  extractActualConstructors(Rest, Exports, Tmp2, New).
extractActualConstructors([_|Rest], Exports, Old, New):-
  extractActualConstructors(Rest, Exports, Old, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% modifyPreludesTable([c(Name,_,_)|Rest, ActualConsts, Accu, Result)
%
% deletes constructors in the prelude that actually are variables
% (marked by c(..))
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
modifyPreludesTable([], _, L, L).
modifyPreludesTable([c(Name,_,_)|Rest], ActualConsts, Accu, Result):-
  !,
  if(
       member(c(Name), ActualConsts),
       modifyPreludesTable(Rest, ActualConsts, [c(Name,prelude,Name)|Accu], Result),
       modifyPreludesTable(Rest, ActualConsts, Accu, Result)
    ).

modifyPreludesTable([E|Rest], ActualConsts, Accu, Result):-
  modifyPreludesTable(Rest, ActualConsts, [E|Accu], Result).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% pass1(SymbolTable, ImportChain, Checked, PreludesExp)
%
% reads the interfaces and computes what every module exports. If B 
% imports some entities from C, and A imports B completely, then
% A also needs the entities that B imported from C (checkAndExpand).
% The results are the Symbol table ([(File, [ModList])], where
% Modlist=[(Module, Imports, Exports, Used)]), the import chains
% (i.e. linearizations of the import tree), a list of the checked
% modules and a list of the entities exported by PreludesExp.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

pass1(GIL, ImportChain, Checked, PreludesExp2, ROOTMod):-
  !,
  % first of all, read the prelude (for operator decls)
  % readHeaders(prelude, PGILTmp, [], _, 'creating preludes'),
  % already done (necessary for modules without mod-decls)
  preldefs(PGILTmp),
  retractall(preldefs(_)),
  readHeaders(ROOTMod, GILTmp, [], Checked, creating),
  %buildAndCheckImportChains(GILTmp, main, ImportChain),
  % expensive !!
  %readHeaders(prelude, PGILTmp, [], _, 'creating preludes'),
  buildAndCheckImportChains(PGILTmp, prelude, _),  %PImportChain
  PGILTmp=[(_, [(_,_,PreludesExp,_)])],
  write('adding preludes definitions ...'),nl,
  remove_duplicates(PreludesExp,PreludesExp2),
  addPrelDef(GILTmp, PreludesExp2, [], GILTmp2),
  %write(GILTmp),nl,nl,write(GILTmp2),nl,nl,
%  printGIL(GILTmp2),nl,nl,
  write('checking interfaces'' dependencies ...'),nl,
  buildAndCheckImportChains(GILTmp2, ROOTMod, ImportChain),
  %printGIL(GILTmp2),nl, 
  checkAndExpand(GILTmp2, ImportChain, GIL),
  checkGenerally(GIL).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% pass2(ModList,
%       OldEntityList, NewEntityList,
%       OldSymbtab, NewSymbtab,
%       OldCheckedModules, NewCheckedModules
%       OldCheckedFiles, NewCheckedFiles,
%       KnownNames,
%       PreludeExports)
%
% reads the implementations. If it is necessary, the modules imported
% by one implementation are added to the symbol table. 
% ModList is a list of the implementations
% to be read, the EntityLists contain renamings and op. declarations
% of the read modules (form (Mod, [Entities])), CheckedModules and
% CheckedFiles are clear. KnownNames is a list of the known names,
% i.e. an image of the whole name space. PreludeExports is what
% the prelude exports; it's the minimal functionality of every module.
% Here we are only interested in building possible parallel import
% trees, in the renamings and in operator declarations. The implemen-
% tations of functions will be read in readImplementations.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% first arg: checkedModules
% last argumnet: preludes exp.
pass2([], EntL,EntL, GIL,NewGIL, Mods,Mods, Files,Files, KnownNames,_):- 
  % let's check imports against exports and renamings
  % To check the imports/exports we replace the interface's imports
  % by the implementation's import,
  removeImports(GIL, Mods, [], TmpGIL),
  addImplImports(EntL, TmpGIL, GILToCheck),
  write('checking modules'' imports ...'),nl,
  checkImpExp(GILToCheck),
  checkImplRenamings(EntL, GILToCheck),
  checkForDoubleEntities(GILToCheck),
  write('creating name spaces ...'),nl,
  buildKnownNames(EntL, GILToCheck, [], KnownNs),
  remove_duplicates(KnownNs,KnownNames),
  NewGIL=GILToCheck.

pass2([M|Ms],OldEntL,NewEntL,OldGIL,NewGIL,OldChMods,NewChMods,OldChFiles,NewChFiles,KnownNames,PreludesExp):-
  implementationInFile(M, File),
  addExtension(File, '.fl', FileWithExt),
  if(
       ownmember(FileWithExt, OldChFiles),
       (
	  TmpEntL=OldEntL,
	  TmpGIL=OldGIL,
	  TmpChMods=OldChMods,
	  TmpChFiles=OldChFiles,
	  TmpMs=Ms
       ),
       (

          % what does the implementation import?
	  collectImports(File, (File, ModL), implementation),
 
   	  makeImpModList(ModL, [], ImpModList),
          % and the interface?
          interfaceInFile(M, InterfFile),
          addExtension(InterfFile, '.int', InterfFileWithExt),
          if(
               ownmember(InterfFileWithExt, OldChFiles),
               (
                  ImpList1=ImpModList,
                  ChFiles1=OldChFiles
               ),
               (
                  collectImports(InterfFile, (InterfFile, MML), interface),
                  ownappend(OldChFiles, [InterfFileWithExt], ChFiles1),
                  makeImpModList(MML, [], InterfImports),
                  ownappend(ImpModList, InterfImports, ImpList1)
               )
            ),
          ownappend(OldEntL, ModL, TmpEntL),
   	  % which modules are imported in this file?

          % !!!!!!!!!!!!!!!!!!!!
          % HIER IST ES TEUER!!!! DENN im folgenden Praedikat wird jedesmal
          % checkGenerally aufgerufen.
          % !!!!!!!!!!!!!!!!!!!!

	  lookForUncheckedModules(ImpList1,OldChMods,TmpChMods,OldGIL,TmpGIL, PreludesExp),
          list_to_ord_set(OldChMods, OS1),
          list_to_ord_set(TmpChMods, OS2),
          % OS3 are modules which are yet unchecked
          ord_subtract(OS2, OS1, OS3),
          % we need the filename extensions  (interfaces --> .int)
          addExtToSet(OS3, [], OS4),
	  % At this point we do not care if an implementation is really used.
	  % While reading the interfaces we distinguished between needed ('used')
	  % and not needed ('unused') modules. So now it can happen that we 
	  % read an implementation, compute it's chain of imports and put it
	  % into the symbol table whilst this implementation is never needed!
	  ownappend(Ms, OS3, NewMs),
	  remove_duplicates(NewMs, TmpMs),
	  % Still to do: renamings!
	  ownappend([FileWithExt|OS4], ChFiles1, TmpChFiles)
       )
    ),
  pass2(TmpMs,TmpEntL,NewEntL,TmpGIL,NewGIL,TmpChMods,NewChMods,TmpChFiles,NewChFiles,KnownNames,PreludesExp).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addExtToSet(Modules, Accu, Result)
%
% adds '.int', the interfaces' extension, to
% every element of Modules.
%
% This predicate is exclusively used by addExtToSet
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addExtToSet([], L, L).
addExtToSet([F|Fs], Accu1, Res1):-
  interfaceInFile(F, FFile),
  addExtension(FFile, '.int', NewF1),
  ownappend([NewF1], Accu1, Tmp1),
  addExtToSet(Fs, Tmp1, Res1).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renF(Term, TranslationTable, RenamedTerm, InModule, ROOTMod, Action)
%
% renames 'Term' (i.e. all subterms in 'Term') according to the
% TranslationTable. The renaming has to be done for 'InModule',
% the result will be stored in 'RenamedTerm'. If a subterm of
% Term does not occur in the TranslationTable, this subterm is
% prefixed by it's modules name, but only if Action==prefixIt.
% prelude's entities are not prefixed.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renF(F, _, F, prelude, _, _):-!.   %no prefixing for prelude's definitions
renF(F, TrTable, FRen, InMod, ROOTMod, Action):-
  if(
       nonvar(F),
       (  
	  F=..[Top|Args],
	  if(
	       member((Top, Toprenamed), TrTable),
	       true,
	       if(
		    (reserved(Top);
                     number(Top);
                     globalType(Top)),   %;(InMod==ROOTMod)),
		    Toprenamed=Top,
		    (
                       %detectVariable(Top, InMod),
                       if(
                            Action==prefixIt,
                            (
		               name(Top, TopAscii),
              		       name(InMod, IMAscii),
                               % 95 is ascii of '_'
		               ownappend(IMAscii, [95|TopAscii], NewAscii),
		               name(Toprenamed,NewAscii)
                            ),
                            Toprenamed=Top
                         )
		    )
	       )
	    ),
	  renFArgs(Args, [], Argsrenamed, TrTable, InMod, ROOTMod, Action),
	  FRen=..[Toprenamed|Argsrenamed]
       ),
       FRen = F
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renFArgs/5
%
% renames the arguments of a given function;
% cf. renF/4
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renFArgs([],A,A,_,_,_,_).
renFArgs([A|As], ArgsRenOld, ArgsRenNew, TrTable,InMod,ROOTMod,Action):-
  renF(A, TrTable, ARen,InMod,ROOTMod,Action),
  ownappend(ArgsRenOld, [ARen], Tmp),
  renFArgs(As, Tmp, ArgsRenNew, TrTable,InMod,ROOTMod,Action).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renTermDetVars(F, TrTable, FRen, InMod, ROOTMod, NotVars, VarsAccu, Vars)
% (renane Terms and detect Variables)
%
% renames 'F' (i.e. all subterms in 'F') according to the
% TranslationTable. The renaming has to be done for 'InMod',
% the result will be stored in 'FRen'. If a subterm of
% Term does not occur in the TranslationTable, this subterm is
% prefixed by it's modules name. Variables will be renamed to
% Prolog variables. NotVars is a list of entities which certainly
% are no variables, Vars and VarsAccu contain lists of variables in
% the term (two 'a's have to be renamed by the same variable).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renTermDetVars(F, TrTable, FRen, InMod, ROOTMod, NotVars, VarsAccu, Vars):-
  if(
       nonvar(F),
       (  
	  F=..[Top|Args],
%          if(Top==where), (write(''),write(Args),nl,nl),true),
	  if(
	       member((Top, Toprenamed), TrTable),
	       NewVars=VarsAccu,
	       if(
		    (
                        reserved(Top);
                        number(Top);
                        globalType(Top)
                    ),
		    (
                        Toprenamed=Top,
                        NewVars=VarsAccu
                    ),
		    (
                       detectVariable(Top, InMod,NotVars,VarsAccu,NewVars),
                       if(
                            InMod==prelude,  %no prefixing for prelude
                            Toprenamed=Top,
                            (
	                       name(Top, TopAscii),
       		               name(InMod, IMAscii),
                               % 95 is ascii of '_'
                               ownappend(IMAscii, [95|TopAscii], NewAscii),
		               name(Toprenamed,NewAscii)
                            )
                         )
		    )
	         )
	    ),
	  renTermDetVarsArgs(Args, [], Argsrenamed, TrTable, InMod, ROOTMod, NotVars, NewVars, NewVars2),
          if(
               member((Top,FasVar), NewVars2),
               makeApplyList(Argsrenamed, FasVar, FRen),
	       FRen=..[Toprenamed|Argsrenamed]
            ),
          Vars = NewVars2
       ),
       (
          FRen = F,
          Vars = VarsAccu
       )
    ).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renTermDetVarsArgs([],A,A,_,_,_,_, V, V)
%
% cf. renTermDetVars. This predicate is for the subterms.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renTermDetVarsArgs([],A,A,_,_,_,_, V, V).
renTermDetVarsArgs([A|As], ArgsRenOld, ArgsRenNew, TrTable, InMod, ROOTMod, NoVars, AccuVars, Vars):-
  renTermDetVars(A, TrTable, ARen, InMod, ROOTMod, NoVars, AccuVars, NewVars),
  ownappend(ArgsRenOld, [ARen], Tmp),
  renTermDetVarsArgs(As, Tmp, ArgsRenNew, TrTable, InMod,ROOTMod,NoVars, NewVars, Vars).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% detectVariable(Symbol, Module, NoVars, VarsAccu, Vars)
%
% checks if Symbol is a Variable in module Module, and if so, replaces
% it by a Prolog-Variable. NoVars is a list of entities which certainly 
% are no variables, VarsAccu and Vars contain a list of variables
% in the term.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

detectVariable(Symbol, Module, NoVars, VarsAccu, Vars):-
  globalTable(GT),
  member((_,ModList), GT),
  member((Module, _, Exports, _), ModList),
  !,
  if(
        Module==prelude,
        (
            findall(Z, (member(d(_=Y,_,_),Exports), makeTopLevelConstructorList(Y, [], Z)), Consts),
            ownflatten(Consts, CList)
        ),
 	(
	  root_module(RMAscii),name(RM, RMAscii),
	  if(RM==Module,
	     actualRootConstructors(CList),
             actualConstructors(CList)
            )
	)
    ),
%  findall(c(CoName), member(c(CoName,_,_), Exports), ConstsFromGIL),
%  ownappend(ConstsFromGIL, CList1, CList2),
%  remove_duplicates(CList2, CList),
  if(
       (
          (member(c(Name), CList), functor(Name,Symbol,_));
          member(f(Symbol,_,_,_,_,_), Exports);
          (member(d((Sym=_),_,_), Exports), functor(Sym,Symbol,_));
          member(d(Symbol,_,_), Exports);
          member(Symbol, NoVars)
       ),
       Vars=VarsAccu,
       (
          if(
               \+ \+ member((Symbol, _), VarsAccu),
               Vars=VarsAccu, 
               (
                  var(NewVar),
                  Vars=[(Symbol, NewVar)|VarsAccu]
               )
            )
%          format(user_output, "guessing ~w is a variable in module ~w\n", [Symbol, Module])
       )
    ),
  !.

detectVariable(_,_,_, V, V).
       


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeApplyList(Args, Accu, Result)
%
% if Args=[a1, .., an], then the Result will be
% Accu@a1@...@an.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeApplyList([], L,L).
makeApplyList([A|Args], Accu, Result):-
  Tmp=..[@,Accu,A],
  makeApplyList(Args,Tmp,Result).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addPrelDef(GIL, PreludesExports, Accu, NewGIL)
%
% adds the PreludesExports to the exports of every module occuring
% in the symbol table GIL.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addPrelDef([], _, L, L).
addPrelDef([(File, ModL)|Rest], Prelude, Accu, New):-
  addPrelDef2(ModL, Prelude, [], NewModL),
  ownappend([(File, NewModL)], Accu, Tmp),
  addPrelDef(Rest, Prelude, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addPrelDef2/4
%
% Level 2 for adding the prelude's definitions
% to every export; cf. addPrelDef/4
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addPrelDef2([], _, L, L).
addPrelDef2([(M,I,E,U)|Rest], Prelude, Accu, New):-
  if(
       member(prelude, I),    %functor(P, prelude, _)),
       Tmp=Accu,
       (
	  ownappend(E, Prelude, NewExp),
	  ownappend([(M, I, NewExp, U)], Accu, Tmp)
       )
    ),
    addPrelDef2(Rest, Prelude, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% lookForUncheckedModules(ModList, OldChecked, NewChecked, OldGIL, 
%                         NewGIL, PrelExps)
%
% looks if the modules in ModList have already been added to the
% symbol table (i.e. if their "transitive import closure" has already
% been built). The resultr is the new symbol table, NewGIL, and a list
% of all checked modules, NewChecked (which contains at least
% OldChecked). PrelExps are the exports of the prelude
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

lookForUncheckedModules([], A, A, B, B, _).
lookForUncheckedModules([M|Ms], OM, NM, OG, NG, PrelExp):-
  % modify global symbol table, if necessary
  implImports(M, OM, TmpM, OG, TmpG, PrelExp),
  lookForUncheckedModules(Ms, TmpM, NM, TmpG, NG, PrelExp).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeImpModList(ModImpExp, Accu, ModList)
%
% ModImpExp is a list of the form (Module, Imports, Exports). 
% makeImpModList/3 returns a list of all imported modules WITHOUT
% possibly specified entities to be imported.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeImpModList([], L, L).
makeImpModList([(_,Imp,_)|Rest], Accu, ModList):-
  extractModNames(Imp, [], ModNames),
  append(ModNames, Accu, TmpModList),
  makeImpModList(Rest, TmpModList, ModList).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extractModNames(ModList, Accu, ModNames
%
% ModList is a list of modules to be imported, possibly together
% with a list of entities (i.e. modul([ent1, ent2])). This
% predicate returns a list of module names without the specified
% entities.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extractModNames([], L, L).
extractModNames([I|Is], Accu, ModNames):-
  functor(I, F, _),
  append([F], Accu, TmpModNames),
  extractModNames(Is, TmpModNames, ModNames).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addImplImports(ModImpExp, GIL, NewGIL)
%
% ModImpExp is a list of the form (Module, Imports, Exports). In
% the Global Import Table the 'Modules' imports are replaced by
% 'Imports'.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addImplImports([], L, L).
addImplImports([(Mod,Imp,_)|Rest], GIL, NewGIL):-
  append(LeftGIL, [(File, ModL)|RightGIL], GIL),
  % there can be modules in the ModImpExp-list that nobody needs
  % (it was time-consuming to decide whether a module was needed or
  % not, so we did not do it!).
  append(LeftModL,[(Mod,_,E,U)|RightModL], ModL),
  !,
  % Exp contains the renamings and operators of the implementation,
  % E those of the interface
  %checkImplRenamings(Exp, GIL),
  ownappend(LeftModL,[(Mod,Imp,E,U)|RightModL], NewModL),
  ownappend(LeftGIL, [(File, NewModL)|RightGIL], TmpGIL),
  addImplImports(Rest, TmpGIL, NewGIL).

% there can be modules in the ModImpExp-list that nobody needs
% (it was time-consuming to decide whether a module was needed or
% not, so we did not do it!).
addImplImports([(_, _,_)|Rest], GIL, NewGIL):-
  !,
  addImplImports(Rest, GIL, NewGIL).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkImplRenamings(ModImpExp, GIL),   /4
%
% checks if there are no unallowed renamings in the implementations,
% i.e. if only imported entities are renamed, if there are no double
% renamings, if every renaming in done in existing modules, etc.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkImplRenamings([], _).
checkImplRenamings([(Mod, Imp, Exp)|Rest], GIL):-
  checkImplRenamings(Exp, Imp, Mod, GIL),
  checkImplRenamings(Rest, GIL).

checkImplRenamings([], _, _, _).
checkImplRenamings([r(From,_,InMod)|Rest], Imp, Mod, GIL):-
  if(
       (member(K, Imp), ((K=InMod); functor(K, InMod, _))),
       true,
       (
	  format(user_error,
		 "\n*** Error: Module ~w renames ~w in module ~w, \c
                  but does not import this module.\n",
		 [Mod, From, InMod]),
	  !,
	  fail
       )
    ),
  !,
  if(
       (
	  append(_, [(_,ModL)|_], GIL),
	  append(_, [(InMod, _, E, _)|_], ModL)
       ),
       (
	  % module exists!
	  !,
          if(
	       (
		  (member(d(F1=_, _, _), E),functor(F1,From,_));
		  (member(d(F2,_,_), E),functor(F2,From,_));
		  (member(c(F3, _, _), E),functor(F3,From,_));
		  (member(f(F4,_,_,_,_,_), E),functor(F4,From,_))
	       ),
	       !,
	       (
		  format(user_error,
			 "*** ERROR: In module '~w', the unknown entity '~w' \c
                          is renamed.\n", [Mod,From]),
		  !,
		  fail
	       )
	     ),
	  if(
	       (  % inefficient! redo 'member' with the list without r(...)!!
		  member(r(From, T, I), E), 
		  delete(E, r(From,T,I), ENew),
		  member(r(From, _, _), ENew)
	       ),
	       (
		  format(user_error,
			 "\n*** ERROR: In module '~w', '~w' is renamed more than once.\n",
			 [Mod, From]),
		  !,
		  fail
	       ),
	       true
	     )
       ),
       (
	  % this case is subsumed by the first literals of this predicate;
	  % here we only look whether a module occurs in the GIL, whilst
	  % above we also look if a renaming is done in an imported
	  % module.
	  format(user_error,
		 "*** Error: renaming in unknown module ~w.\n",
		 [InMod]),
	  !,
	  fail
       )
    ),
  checkImplRenamings(Rest, Imp, Mod, GIL).
       
% don't care now for operators
checkImplRenamings([o(_,_,_,_,_)|Rest], Imp, Mod, GIL):-
  checkImplRenamings(Rest, Imp, Mod, GIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildKnownNames(ModImpExpList, GIL, Accu, Result)
%
% creates the foreign name space of a module, i.e. computes all the
% names that are known (=imported) by this module.
% ModImpExpList is the list of imports and exports of modules' 
% IMPLEMENTATIONs (so the "exports" only consist of operators and 
% renamings). GIL is the global import/export table (which is
% determined only by the modules' inerfaces).
% To create a list of all known entities, the import list of every
% module occuring in ModImpExpList is deleted in the GIL and 
% replaced by the imports of the implementation. Then the transitive
% closure of this import-relation is built (addExports/5 in bKN/5)
% and put in the export field of the current module. Result is
% a list of the form (Module, [KnownNames]).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildKnownNames([], _, L, L).
buildKnownNames([(Mod, Imp, Expp)|Rest], GIL, Accu, Result):-
  removeOperators(Expp, [], Exp),
  append(LeftGIL, [(File, ModL)|RightGIL], GIL),
  append(LeftModL, [(Mod, _, _, _)|RightModL], ModL),
  !,
  append(LeftModL, [(Mod, Imp, Exp, used)|RightModL], NewModL),
  append(LeftGIL, [(File, NewModL)|RightGIL], NewGIL),
  !,
  % Mod is the calling module
  bKN(Mod, Imp, NewGIL, TmpKnownNames),
  append(LeftGIL, [(File, ModL2)|RightGIL], TmpKnownNames),
  append(_, [(Mod, _, KnownNames, _)|_], ModL2),
  !,
  append(Accu, [(Mod, KnownNames)], TmpResult),
  buildKnownNames(Rest, GIL, TmpResult, Result).

% for implementations that were read but are not needed
% ('unused' implementations)
buildKnownNames([(_,_,_)|Rest], GIL, Accu, Result):-
  buildKnownNames(Rest, GIL, Accu, Result).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% bKN(CallingMod, Imports, AccuGIL, NewGIL)
%
% computes the transitive closure of the imports of CallingMod. 'Imports'
% is a list of the imported modules, AccuGIL the current symbol table.
% The desired entities of every imported module are stored in the
% Import-parts of the symbol table and most important for the
% correctness of this algorithm.
%
% bKN/4 is exlusively used by buildKnownNames/5
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bKN(_, [], L, L).
bKN(CallingMod, [M|Ms], AccuGIL, NewGIL):-
  functor(M, CdM, _),
  functor(CallingMod, CgM, _),
  makeModExportsList(AccuGIL, CdM, CalledExports),
  % here is the interesting point where only stated
  % entites are imported
  addExports(CdM, CgM, CalledExports, AccuGIL, TmpGIL),
  bKN(CallingMod, Ms, TmpGIL, NewGIL). 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeOperators(List, Accu, New)
%
% removes all o(_,_,_,_,_) from List and stores the result in New.
% List normally is an "export list" of an implementation, i.e.
% consists only of renamings and operators, so that the result
% is a list of renamings.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeOperators([], L, L).
% delete with anonymous arguments does not work!
removeOperators([o(_,_,_,_,_)|Rest], Accu, New):-
  !,
  removeOperators(Rest, Accu, New).
removeOperators([R|Rest], Accu, New):-
  ownappend([R], Accu, Tmp),
  removeOperators(Rest, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  declareImplOperators(Module, EntityList), declOp/2
%
% EntityList is a list of renamings and operators occuring in the
% modules' implementations. This predicate looks for operator
% declarations in 'Module's' (o(Name,...)) scope and defines them.
% The operator definitions that are done here may be overwritten.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

declareImplOperators(Module,EntityList):-
  % why do we need a findall here?
  findall([], declOp(Module,EntityList), _).
 

% declare operators to be able to read implementations from files
% to do: forget prefixing of prelude-ops.
declOp(Module, EntityList):-
  % using non-determinism -- no cuts!
  if(
       member((Module, _, Exp), EntityList),
       if(
	    member(o(Name,Prio,Kind,_,_), Exp),
	    (
	       name(Module, OMAscii),
	       name(Name, ONAscii),
	       append(OMAscii, ONAscii, OrigName),
	       name(NewName, OrigName),
	       %write('declared ... '),write(NewName),nl,
	       % prefix-ops do not have to be declared
	       if(
		    Kind=ix, 
		    (
		       op(Prio, xfx, (NewName)), 
		       op(Prio, xfx, (Name))
		    ),
		    true
		 ),
	       if(
		    Kind=ixl, 
		    (
		       op(Prio, yfx, (NewName)), 
		       op(Prio, yfx, (Name))
		    ),
		    true
		 ),
	       if(
		    Kind=ixr, 
		    (
		       op(Prio, xfy, (NewName)), 
		       op(Prio, xfy, (Name))
		    ),
		    true
		 )
	    ),
	    true
	 ),
       true
    ).

	    
  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildTranslationTable(KnownNames, Mod, CurrentlyKnown,ROOTMod)
%
% builds a table (Name, NewName) of names of entities in 'KnownNames'
% where 'NewName' is 'Name' prefixed by 'Mod'. makeNewNames/3 is
% invoked by this predicate, and there operator declarations will be
% made. ROOTModule's entities are not prefixed.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildTranslationTable(KnownNames, Mod, CurrentlyKnown,ROOTMod):-
  ownmember((Mod, Entities), KnownNames),
  % in makeNewNames the occuring operators are locally defined
  % in the sense that their definition can be overwritten
  makeNewNames(Entities, [], TmpCurrentlyKnown,ROOTMod),
  % we also need the prelude's definitions.
  ownmember((prelude, PrelEnt), KnownNames),
  makeNewNames(PrelEnt, [], PrelKnown,ROOTMod),
  ownappend(PrelKnown, TmpCurrentlyKnown, CurrentlyKnown2),
  remove_duplicates(CurrentlyKnown2, CurrentlyKnown),
  safi(checkAgainDoubleEntities(CurrentlyKnown,Mod)).




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeNewNames(EntityList, AccuNames, NewNames, ROOTMod)
%
% in EntityList are stored any (not every!) module's entities in
% the form d(...), c(...) etc. The last two components are the
% original module and the original name, which are concatenated
% and also form the new name.
% Example: d(arbre(A)=...,datstructs,tree(A)) will lead to a new
%          entity called 'datstructsarbre'.
%
% The pairs (original name, new name) are stored in NewNames.
%
% If there are operator declarations (to be found in 
% f(Name, Signature, Priority, Kind, OrigMod, OrigName) if
% Kind#px), then two operators are declared: 'original name' and 
% 'new name'. 'new name' is globally accessible and may not be over-
% written; 'name' may be locally redefined.
% Entities in prelude are not prefixed
% ROOTMod is necessary if one does not want to prefix rootmods entities.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% forget prefixing of prelude-ops  
makeNewNames([d(N=_, prelude, _)|Es], Accu, NewNames, ROOTMod):-
  %((M=prelude);(M=ROOTMod)),
  !,
  functor(N,F,_),
  ownappend([(F,F)], Accu, Tmp),
  makeNewNames(Es, Tmp, NewNames, ROOTMod).
makeNewNames([d(N, prelude, _)|Es], Accu, NewNames, ROOTMod):-
%  ((M=prelude);(M=ROOTMod)),
  !,
  functor(N,F,_),
  ownappend([(F,F)], Accu, Tmp),
  makeNewNames(Es, Tmp, NewNames, ROOTMod).
makeNewNames([c(N, prelude, _)|Es], Accu, NewNames, ROOTMod):-
%  ((M=prelude);(M=ROOTMod)),
  !,
  functor(N,F,_),
  ownappend([(F,F)], Accu, Tmp),
  makeNewNames(Es, Tmp, NewNames, ROOTMod).
makeNewNames([f(N, _, _, _, prelude, _)|Es], Accu, NewNames, ROOTMod):-
%  ((M=prelude);(M=ROOTMod)),
  !,
  functor(N,F,_),
  ownappend([(F,F)], Accu, Tmp),
  makeNewNames(Es, Tmp, NewNames, ROOTMod).

makeNewNames([f(N, _, prelude, _)|Es], Accu, NewNames, ROOTMod):-
%  ((M=prelude);(M=ROOTMod)),
  !,
  functor(N,F,_),
  ownappend([(F,F)], Accu, Tmp),
  makeNewNames(Es, Tmp, NewNames, ROOTMod).

% 95 is underscore (_)
makeNewNames([], L, L, _):-!.
makeNewNames([d(Name=_, OM, ON)|Es], Accu, NewNames, ROOTMod):-
  !,
  functor(Name, F, _),
  name(OM, OMAscii),
  functor(ON, ONF, _),
  name(ONF, ONAscii),
  ownappend(OMAscii, [95|ONAscii], OrigName),
  name(NewName, OrigName),
  ownappend([(F, NewName)], Accu, TmpNames),
  makeNewNames(Es, TmpNames, NewNames, ROOTMod).
makeNewNames([d(Name, OM, ON)|Es], Accu, NewNames, ROOTMod):-
  !,
  functor(Name, F, _),
  name(OM, OMAscii),
  functor(ON, ONF, _),
  name(ONF, ONAscii),
  ownappend(OMAscii, [95|ONAscii], OrigName),
  name(NewName, OrigName),
  ownappend([(F, NewName)], Accu, TmpNames),
  makeNewNames(Es, TmpNames, NewNames, ROOTMod).
makeNewNames([c(Name, OM, ON)|Es], Accu, NewNames, ROOTMod):-
  !,
  functor(Name, F, _),
  name(OM, OMAscii),
  functor(ON, ONF, _),
  name(ONF, ONAscii),
  ownappend(OMAscii, [95|ONAscii], OrigName),
  name(NewName, OrigName),
  ownappend([(F, NewName)], Accu, TmpNames),
  makeNewNames(Es, TmpNames, NewNames, ROOTMod).
% 3rd pos. evtl. 'none'
makeNewNames([f(Name, _, Prio, Kind, OM, ON)|Es], Accu, NewNames, ROOTMod):-
  !,
  functor(Name, F, _),
  name(OM, OMAscii),
  functor(ON, ONF, _),
  name(ONF, ONAscii),
  ownappend(OMAscii, [95|ONAscii], OrigName),
  name(NewName, OrigName),
  

  % prefix- ops must not be declared
  % the composed operators' names are unambiguous. Once they are 
  % declared, they are never overwritten.
  if(
       Kind=ix, 
       (
          %write(NewName),write(' and '),write(Name),write(' declared ...'),nl,
	  op(Prio, xfx, (NewName)), 
	  op(Prio, xfx, (Name))
       ),
       true
    ),
  if(
       Kind=ixl, 
       (
          %write(NewName),write(' and '),write(Name),write(' declared ...'),nl,
	  op(Prio, yfx, (NewName)), 
	  op(Prio, yfx, (Name))
       ),
       true
    ),
  if(
       Kind=ixr, 
       (
          %write(NewName),write(' and '),write(Name),write(' declared ...'),nl,
	  op(Prio, xfy, (NewName)), 
	  op(Prio, xfy, (Name))
       ),
       true
    ),
  ownappend([(F, NewName)], Accu, TmpNames),
  makeNewNames(Es, TmpNames, NewNames, ROOTMod).

makeNewNames([_|Es], Accu, TmpNames, ROOTMod):-
  makeNewNames(Es, Accu, TmpNames, ROOTMod).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% implImports(RootModule, OldChecked, NewChecked, OldGIL, NewGIL, PrelExp)
%
% will be called in the following situation:
% An implementation imports a module, that has not been imported by
% any interface so far. In this case, this module serves as new
% root module ("root" of the import chains), and the import chains
% will be followed until the first known module is detected ("known"
% means that it has already been imported). This is achieved by
% temporarily deleting the import lists of all known modules.
% The original import table and this new one are merged, the
% export lists are built and finally the import lists have to
% be re-inserted.
%
% parameters: - RootModule
%               module imported by an implementation
%             - OldChecked
%               List of modules that are 'used' so far
%             - NewChecked
%               List of new 'used' modules
%             - OldGIL
%               Old global Import/Export Table
%             - NewGIL
%               New global Import/Export table.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

implImports(RootModule, OldChecked, NewChecked, OldGIL, NewGIL, PrelExp):-
  if(
       ownmember(RootModule, OldChecked),
       (
	  NewChecked=OldChecked,
	  NewGIL=OldGIL
       ),
       (
	  readHeaders(RootModule, LocalTable2, OldChecked, NewChecked, modifying),
          % add preludes def. to the LocalTable:
          addPrelDef(LocalTable2, PrelExp, [], LocalTable),
	  removeImports(OldGIL, OldChecked, [], OldGILWithout),
	  % merge first arg. into the second
	  mergeTables(LocalTable, OldGILWithout, NewLocalTable),
	  % Now we have the original table with the new modules. The old
	  % modules will be the ends of the import chains, as their import
	  % tables are (temporarily) empty.
	  buildAndCheckImportChains(NewLocalTable, RootModule, ImpChains),
	  checkAndExpand(NewLocalTable, ImpChains, TmpGIL),
	  % Last step: re-insert the import lists of the old modules:
	  removeModules(TmpGIL, OldChecked, [], TmpGIL2),
	  mergeTables(TmpGIL2, OldGIL, NewGIL),
	  % check renamings and import-export-relationship.
	  checkGenerally(NewGIL)
       )
    ).
  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% readHeaders(RootModule, GlobalTable, OldChecked, 
%             NewChecked, CreateOrModify)
%
% reads interfaces. Starting by RootModule, readHeaders looks for
% other interfaces to be imported and stores them in the GlobalTable,
% unless they are not already 'used'. These 'used' modules are
% the elements of OldChecked; NewChecked is an updated version of this
% list. CreateOrModify should be 'creating' or 'modifying' and is
% only for the output.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% last parameter: CreateOrModify
readHeaders(RootModule, GlobalTable, OldChecked, NewChecked, _):-
  %format(user_output,
%	 "reading headers and ~w global export table ...\n", [CreateOrModify]),
  interfaceInFile(RootModule, RootFile),
  collectImports(RootFile, (RootFile,ToBeImported), interface),
  % check if there is a root-module in this file
  if(
       ownmember((RootModule,(MainImpL,_)), ToBeImported),
       (
	  addTag(ToBeImported,[],SL),
	  buildImportTable(MainImpL, [(RootFile,SL)], ResL, OldChecked, NC),
	  ownappend(NC, [RootModule], NC2),
	  remove_duplicates(NC2, NewChecked),
	  %format("\nchecked modules: ~w\n", [NewChecked]),
	  markUsed(RootFile, RootModule, ResL, GlobalTable),   %GlobalTable=ImpL
	  %format(user_output,
	%	 "checking dependencies and module names ...\n", []),
	  checkForDoubleModNames(GlobalTable)
       ),
       (
	  format(user_error, 
		 "\n*** Error: File '~w' contains no module called '~w'.\n",
		 [RootFile, RootModule]),
	  !,
	  fail
       )
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkAndExpand(GlobalImportTable, ImportChains, NewGlobalImportTable)
%
% checks the GlobalImportTable for double renamings and expands the
% exports (i.e. computes the exports for every module). 
% checkAndExpand needs the import chains (which usually are returned
% by buildAndCheckImportChains/3).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkAndExpand(ImpL, IC, NewGIL):-
  % has to be done BEFORE the ExpLists are expanded
  % as otherwise there will be the wrong error statement:
  checkDoubleRenamings(ImpL),
  addOps2Funcs(ImpL, [], NEW),
  % format(user_output, "chain of imports:\n~w\n", [IC]),
  %format(user_output, "expanding export lists ...\n", []),
  computeExports(IC, NEW, ExpGIL),
  %format(user_output,
%	 "checking for double renamings and consistency of imports/exports ...\n",
%	 []),
  %checkForDoubleEntities BEFORE checkIntRenamings (non-determ. will cause
  % backtracking).
  removeDoubleDecls(ExpGIL, NewGIL),
  checkForDoubleEntities(NewGIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkGenerally(GIL)
%
% checks the renamings and the relationship between imports and
% exports (one can only import entities that are exported!)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkGenerally(GIL):-
  checkIntRenamings(GIL),
  checkImpExp(GIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addOps2Funcs(GIL, AccuGIL, NewGIL)
% 
% In the global import table we still have operator (i.e. infix{l,r,#}
% declarations, which we will put in the corresponding function
% definitions (there must be a function associated with each operator)
% as 4th (Priority) and 5th component (kind: x/l/r).
%
% This is done by addOps2Funcs/3. As the global import table is
% nested, we need the auxiliary predicates aO2F/3 which splits up
% the list of imported modules and opPlusFunc/3 which finally looks
% in the export list of a module and achieves the stated operation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addOps2Funcs([], L, L).
addOps2Funcs([(File, ModList)|RestGIL], OldGIL, NewGIL):-
  aO2F(ModList, [], NewModList),
  ownappend([(File, NewModList)], OldGIL, TmpGIL),
  addOps2Funcs(RestGIL,  TmpGIL, NewGIL).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% aO2F/3
%
% cf. addOps2Funcs/3
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

aO2F([], L,L).
aO2F([(M,Imps,Exps,Used)|RestMod], OldModSig, NewModSig):-
  opPlusFunc(Exps, [], NewExps),
  ownappend([(M,Imps,NewExps,Used)], OldModSig, TmpSig),
  aO2F(RestMod, TmpSig, NewModSig).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% opPlusFunc/3
%
% cf. addOps2Funcs/3
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

opPlusFunc([], L, L).

opPlusFunc([f(Name, Signature, OrigMod, OrigName)|RestExp], OldExp, NewExp):-
  ownmember(o(Name, Prio, Kind, OrigMod, OrigName), RestExp),
  !,
  ownappend([f(Name, Signature, Prio, Kind, OrigMod, OrigName)], OldExp, TmpExp),
  delete(RestExp, o(Name, Prio, Kind, OrigMod, OrigName), TmpRest),
  opPlusFunc(TmpRest, TmpExp, NewExp).

opPlusFunc([f(Name, Signature, OrigMod, OrigName)|RestExp], OldExp, NewExp):-
  !,    %ordinary prefix function
  ownappend([f(Name, Signature, none, px, OrigMod, OrigName)], OldExp, TmpExp),
  opPlusFunc(RestExp, TmpExp, NewExp).

opPlusFunc([o(Name, Prio, Kind, OrigMod, OrigName)|RestExp], OldExp, NewExp):-
  ownmember(f(Name,Signature, OrigMod, OrigName), RestExp),
  !,
  delete(RestExp, f(Name,Signature, OrigMod, OrigName), TmpRest),
  ownappend([f(Name, Signature, Prio, Kind, OrigMod, OrigName)], OldExp, TmpExp),
  opPlusFunc(TmpRest, TmpExp, NewExp).

% operator declaration without associated function declaration
opPlusFunc([o((==),_,_,_,_)|Rest], OE, NE):-!,opPlusFunc(Rest,OE,NE).
opPlusFunc([o(Name, _, _, OrigMod, _)|_], _, _):-
  format("\n*** Error: Operator '~w' needs a definition in module '~w'.\n",
	 [Name,OrigMod]),
  fail.

opPlusFunc([E|RestExp], OldExp, NewExp):-
  ownappend([E], OldExp, TmpExp),
  opPlusFunc(RestExp, TmpExp, NewExp).

  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% computeExports(ImpChains, OldGIL, NewGIL)
%
% expands the modules' exports. If a module M1 imports M2 (completely
% or partially), then M1 should also export everything it imported
% of M2. So that's what is done by computeExports: it updates the
% GlobalImportList in the stated sense.
% Parameters:
% 	- ImpChains
%	  List of chains of imports, created by makeImportChains
%	- OldGIL 
%	  old import table (accu)
%	- NewGIL
%	  updated table
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

computeExports([], L, L).
computeExports([MCh1|RCh], OldGIL, NewGIL):-
  % reversing the import chain is the kernel of this algorithm !!!
  % the import chains are reversed, and then the predecessor of
  % the current module will export the entities this current
  % module exports (completely or partially).
  reverse(MCh1, RevChain),
  extIC(RevChain, OldGIL, NewGIL2),
  computeExports(RCh, NewGIL2, NewGIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extIC(ImpChain, OldGIL, NewGIL)
% 
% expands the global import table in the same sense 
% as in the documentation for computeExports.
% extIC works on ONE import chain.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
  
% lists containing at least two members
extIC([H|[T1|TRest]], OldGIL, NewGIL):-
  !,
  % HExps is what the called (left) module exports,
  % T1 is the calling module, H the called one
  makeModExportsList(OldGIL, H, HExps),
  addExports(H, T1, HExps, OldGIL, NewGIL2),
  extIC([T1|TRest], NewGIL2, NewGIL).
  
% lists with only one element (this is main or another root module!)
extIC([_], L, L):-!.
extIC(_, _, _):-format(user_error, "*** internal error\n").


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addExports(CalledM, CallingM, Exps, OldGIL, NewGIL)
%
% CalledM exports Exps. We will now look what CallingM
% needs of it and insert it in the global import table.
%
% addExports is a shortcut for the clauses contained
% in this predicate,
% and is exclusively used by extIC/3.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addExports(CalledMod, CallingMod, Exps, OldGIL, NewGIL):-
  % use append for multiple choices, not ownappend
  % find position in GIL

  % Exps is what the called module exports
  append(L1,[(F,ML)|RL], OldGIL),   %NOT ownappend
  member((CallingMod, IL, EL, 'used'), ML),
  delete(ML, (CallingMod, IL, EL, 'used'), MLNew),
  % remove all renamings in the exports of the called module
  remRen(r(_,_,_), Exps, ExpsNoRens),
  % look what CallingMod needs
  if(
       ownmember(CalledMod, IL),    %whole module is imported
       (
	  % in EL we find the renamings of the calling module,
	  % in EE the renamed entities imported from CalledMod 
%	  write('-- whole mod'),write(EL),nl,
	  renameCompletely(CalledMod, EL, EL, ExpsNoRens, EE)
%	  format("\n\nCgMod: ~w,\n CdMod: ~w,\n Rens: ~w,\n vorher: ~w,\n Rend: ~w\n\n",
%                 [CallingMod, CalledMod, EL, ExpsNoRens, EE])
       ),
       % else: there are specified entities to be imported
       (
	  member(CM, IL),     %ImpList merken
	  CM =.. [CalledMod,ImpList2],!,
	  % flatten ArgList if necessary
	  if(ImpList2=[[A1|B1]], 
	     ImpList=[A1|B1],
	     if(ImpList2=[[X1]], 
	        ImpList=[X1],
		if(ImpList2=[_|_],
		   ImpList=ImpList2,
		   ImpList=[ImpList2]
		  )
	       )
	     ),
	  % now we know that the CallingModule imports ImpList
	  % from the CalledModule and exports EL (incl. renamings).
	  % ExpsNoRens is the export list of the called module
	  % without renaming statements
	  % the 4th argument is EL and not [] because we do an implicit
	  % importing of data type constructors.
	  makeNewExpL(CalledMod, ImpList, ExpsNoRens, EL, EE, Error),
	  if(
	       Error=okay,
	       true,
	       (
		  format(user_error,"\n*** Error: Module '~w' explicitely imports \c
                         constructor '~w' from module '~w'\n",
			 [CallingMod, Error, CalledMod]),
		  !,fail
	       )
	    )
                        
%	  format("2: CgMod: ~w, CdMod: ~w, Needed: ~w, Rens: ~w , vorher: ~w, \nRend: ~w",  [CallingMod, CalledMod, ImpList, EL, ExpsNoRens, EE])

       )
    ),
  ownappend(EL, EE, ELNew2),
  %format("\n\nEL vorher:  ~w ++ ~w\n", [EL, EE]),


  % remove double entities
  list_to_ord_set(ELNew2, ELNewOrdered),
  ownappend([(CallingMod, IL, ELNewOrdered, 'used')], MLNew, MLNew2),
  ownappend(L1, [(F,MLNew2)|RL], NewGIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renameConsts(Consts, CRenOld, CRenNew, CME, Mod)
%
% renames the Constructors stored in Consts (format c1;c2;...) with 
% respect to the renamings that are stored in CME (in our terminology:
% CME is what the calling module exports). Mod is the module in which
% the constructors 'Consts' appear. CrenOld is an accu, CrenNew
% is the result.
% Renaming means: all subterms are renamed (if there are subterms).
%
% renameConsts needs renameFuncArgs/5 and renameFunction/4
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renameConsts((C;Cs), CRenOld, CRenNew, CME, Mod):- 
  !,
  renameFunction(C, NewC, CME, Mod),
  ownappend(CRenOld, [c(NewC,dummy,dummy)], Tmp),
  renameConsts(Cs, Tmp, CRenNew, CME, Mod).
renameConsts(C, CRenOld, CRenNew, CME, Mod):-
  renameFunction(C, NewC, CME, Mod),
  ownappend(CRenOld, [c(NewC,dummy,dummy)], CRenNew2),
  makeSemicolList(CRenNew2, CRenNew).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renameFuncArgs(Args, ArgsRenOld, ArgsRenNew, CME, Mod)
%
% renames the constructor arguments Args to ArgsRenNew
% with respect to the renamings in CME. Current module
% is Mod.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renameFuncArgs([],A,A,_,_).
renameFuncArgs([A|As], ArgsRenOld, ArgsRenNew, CME, Mod):-
  renameFunction(A, ARen, CME, Mod),
  ownappend(ArgsRenOld, [ARen], Tmp),
  renameFuncArgs(As, Tmp, ArgsRenNew, CME, Mod).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renameFunction(F, FRen, CME, Mod)
%
% renames a function F(Args) to F'(Args') with
% respect to the renamings in CME. Current
% module is Mod, i.e. Mod is the module in which
% F was declared (renaming XX to YY in Mod).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renameFunction(F, FRen, CME, Mod):-
  if(
       nonvar(F),
       (  
	  F=..[Top|Args],
	  renamePartially(Top, Toprenamed, CME, Mod),
	  renameFuncArgs(Args, [], Argsrenamed, CME, Mod),
	  FRen=..[Toprenamed|Argsrenamed]
       ),
       FRen = F
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addConstsOrigin/4 /5
%
% adds the original module and the original name to a list of
% constructors.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extrDoubConsts([], L, L).
extrDoubConsts([c(Name,OM,ON)|Rest], Accu, Result):-
  member(c(Name,OM2,ON2), Rest),
  !,
  format(user_output,
	 "*** Error: Illegal use of ~w (originally ~w)\n    \c
	  in module ~w/~w.\n",
	  [Name, ON, OM, OM2]),
  extrDoubConsts(Rest, [(Name, OM, ON, OM2, ON2)|Accu], Result).
extrDoubConsts([_|Rest], Accu, Result):-
  extrDoubConsts(Rest, Accu, Result).

addConstsOrigin(A,B,C,D,E):-
  if(
       addConstsOrigin2(A,B,C,D,E),
       true,
       (  %2nd clause: constructor used at top level on RHS
	  extrDoubConsts(B,[],_),
	  !,
	  fail
       )
    ).
      

addConstsOrigin2([], [], _, L, L).
addConstsOrigin2([],_,_,L,L):-
%  write('*** Internal Error: addConstsOrigin2/5.'),nl,
%  flush_output,
  fail.

% in renameCompletely we already have the original mods and names
addConstsOrigin2([c(RenamedC)|RCs], [c(_,OrigMod,OrigName)|OCs],[],Old,New):-
  !,
  ownappend([c(RenamedC,OrigMod,OrigName)], Old, Tmp),
  addConstsOrigin2(RCs, OCs, [], Tmp, New).


addConstsOrigin2([c(RenamedC)|RCs], [c(OrigC)|OCs], Ex, OldCLst, NewCLst):-
  ownmember(c(OrigC, OrigMod, OrigName), Ex),
  !,
  ownappend([c(RenamedC, OrigMod, OrigName)], OldCLst, Tmp),
  addConstsOrigin2(RCs, OCs, Ex, Tmp, NewCLst).

% Constructor is not really a constructor but a data type.
% This case occurs if the KnownNames for every module are built.
% Reason: When the KnownNames are built, we are working in the
% import/export table of the headers, where superfluous constructor
% markings have been deleted (superfluous in the sense that the algorithm
% remarked that a constructor actually is a data type).
addConstsOrigin2([_|R1], [_|R2], Ex, OldCLst, NewCLst):-
  addConstsOrigin2(R1, R2, Ex, OldCLst, NewCLst).



% addConstsOrigin/4 -- exclusively used by findImports and rI
addConstsOrigin([], _, L, L).
addConstsOrigin([c(C)|Cs], Mod, Old, New):-
  ownappend([c(C, Mod, C)], Old, Tmp),
  addConstsOrigin(Cs, Mod, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% getSubterms/2, /3; getSubtermsAndArity/2, /3; 
% getSubtermsWithoutBottom/2, /3
% (use /2)
%
% extract the heading functors of all subterms and put them into
% a list. In the second case, the arity is also returned: (Sym,Ar).
% The third predicate returns a list of all subterms except
% the bottom level terms.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% /2
getSubtermsAndArity(T, _):-var(T),!.
getSubtermsAndArity(Term, Result):-
  nonvar(Term),
  functor(Term,_,Arity),
  Term=..[F|Args],
  if(
     ((F=',');(F=;);(F=[]);(F='.');(F=(->))),    %-> for functions' type signature 
     Tmp=[], 
     Tmp=[(F,Arity)]
    ),
  !,
  getSubtermsAndArity(Args, [], ArgsL),
  ownappend(Tmp, ArgsL, Result).

% /3
getSubtermsAndArity([], L, L2):-remove_duplicates(L,L2).
getSubtermsAndArity([Arg|Args], Accu, New):-
  getSubtermsAndArity(Arg, AL1),
  ownappend(AL1, Accu, Tmp),
  getSubtermsAndArity(Args, Tmp, New).

% let's ignore bottom level constructors for the moment...
% /2
getSubtermsWithoutBottom(T, _):-var(T),!.
getSubtermsWithoutBottom(Term, Result):-
  nonvar(Term),
  Term=..[F|Args],
  if(
     ((Args==[]);(F=',');(F=;);(F=[]);(F='.');(F=(->))),    %-> for functions' type signature 
     Tmp=[], 
     Tmp=[F]
    ),
  !,
  getSubtermsWithoutBottom(Args, [], ArgsL),
  ownappend(Tmp, ArgsL, Result).

% /3
getSubtermsWithoutBottom([], L, L2):-remove_duplicates(L,L2).
getSubtermsWithoutBottom([Arg|Args], Accu, New):-
  getSubtermsWithoutBottom(Arg, AL1),
  ownappend(AL1, Accu, Tmp),
  getSubtermsWithoutBottom(Args, Tmp, New).


% /2
getSubterms(T, _):-var(T),!.
getSubterms(Term, Result):-
  nonvar(Term),
  Term=..[F|Args],
  if(
     ((F=',');(F=;);(F=[]);(F='.');(F=(->))),    %-> for functions' type signature 
     Tmp=[], 
     Tmp=[F]
    ),
  !,
  getSubterms(Args, [], ArgsL),
  ownappend(Tmp, ArgsL, Result).

% /3
getSubterms([], L, L2):-remove_duplicates(L,L2).
getSubterms([Arg|Args], Accu, New):-
  getSubterms(Arg, AL1),
  ownappend(AL1, Accu, Tmp),
  getSubterms(Args, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeNewExpL(CalledMod, Imports, Ex, CME, CMNEx, Error)
%
% adds the (possibly renamed) entities IMPORTED by a module 
% to its own export list.
%
% module M1 imports from a module 'Mod' the entities stored in 
% the list 'Imports'. 'CME' is the export list of M1 INCLUDING its
% renamings. 'Ex' is the current list of the entities exported
% by CalledMod, without this module's renamings (we do not need
% them, because the renamings have already be done for this module).
% 'CMNEx' finally is the resulting export list.
%
% makeNewExpL is exlusively used by addExports/5.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeNewExpL(_, [], _, E, E, okay).
makeNewExpL(Mod, [Im1|RIm], Ex, CME, CMNEx, Error):-
  member(d(X=Consts, OrigMod, OrigName), Ex), %nondeterministic ==> NOT ownmember
  X=..[Im1|_],
  !,
  renameFunction(X, FuncNew, CME, Mod),
  %renamePartially(Im1, Im1renamed, CME, Mod),
  %FuncNew=..[Im1renamed|Args],
  renameConsts(Consts, [], Constsrenamed, CME, Mod),
  % in the importing module we need the data constructors, too:
  % makeConstructorList returns a list of all Constructors or data types
  % occurring in Consts.
  makeConstructorList(Constsrenamed, [], RenCL),
  makeConstructorList(Consts, [], OrigCL),
  addConstsOrigin(RenCL, OrigCL, Ex, [], NewConstList),
  % we still need all subconstructors of a given constructor
  ownappend([d(FuncNew=Constsrenamed, OrigMod, OrigName)], CME, Ex2),
  ownappend(NewConstList, Ex2, Ex3),
  makeNewExpL(Mod, RIm, Ex, Ex3, CMNEx, Error).

% d(X) for abstract data types
makeNewExpL(Mod, [Im1|RIm], Ex, CME, CMNEx, Error):-
  ownmember(d(Im1, OrigMod, OrigName), Ex),
  !,
  renamePartially(Im1, Im1renamed, CME, Mod),
  ownappend([d(Im1renamed, OrigMod, OrigName)], CME, Ex2),
  makeNewExpL(Mod, RIm, Ex, Ex2, CMNEx, Error).

% constructors cannot explicitely be imported
makeNewExpL(_, [Im1|_], Ex, _, _, Im1):-    %last component: error!
  member(c(X,_,_), Ex),
  X=..[Im1|_].

% operators are only exported together with functions !!!

makeNewExpL(Mod, [Im1|RIm], Ex, CME, CMNEx, Error):-
  ownmember(f(Im1,Types,Prio,Kind,OrigMod,OrigName), Ex),
  !,
  %renamePartially(Im1, Im1renamed, CME, Mod),
  renameFunction(Im1, Im1renamed, CME, Mod),
  renameFunction(Types, TypesRenamed, CME, Mod),
  ownappend([f(Im1renamed,TypesRenamed,Prio,Kind,OrigMod,OrigName)], CME, Ex2),
  % still needed: all datatypes occurring in the function's
  %               type signature.
  getSubterms(TypesRenamed, LLL),
  %auch hier: Typen aufloesen und Datentypdefinitionen mitimportieren
  ownappend(RIm, LLL, NewRIm),
  makeNewExpL(Mod, NewRIm, Ex, Ex2, CMNEx, Error).

% in this case the entity to be imported is either not exported 
% or has not yet been detected in the import chain
makeNewExpL(Mod, [_|RIm], Ex, CME, CMNEx, Error):-
  %  <<AA is _>>  
%  write('looking for '), write(AA),write(' in '), write(Mod),nl,
  makeNewExpL(Mod, RIm, Ex, CME, CMNEx, Error).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renameCompletely(Mod, RenList, RenListCopy, OldExpL, NewExpL)
%
% renames OldExpL, the exported entities of Mod, w.r.t. the renaming
% statements in RenList (which is actually the import list of the
% importing module). Mod is an imported module, which is COMPLETELY
% imported. The result will be returned in NewExpL.
% RenListCopy is a copy of the original RenList and is needed for
% renamings of data consturctors
%
% renameCompletely/5 is exclusively used by addExports/5.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% end of recursion. As a last step, we will rename the constructors.
renameCompletely(M, [], RenLC, OldExL, NewExL):-
  extractConstructors(OldExL, [], CList),
  if(
       CList=[],
       Tmp2=OldExL,
       (
          % if a constructor exists more than once, then we remove the
          % illegally inserted one (which results of an expansion of
          % Cs in d(A=Cs,...)
          %
          findall(c(Name, M, ONforeign), 
                  (member(c(Name, OM1, ONforeign), CList),
                   M\==OM1,
                   member(c(Name, M, _), CList)
                  ), NotFromThisModule),
          % possible: data a=c. data b=c. ==> c appears twice
          remove_duplicates(CList, CListWithoutD),
          if(
               CList\==CListWithoutD,
               (
                  getDoubles(CList, [], DD),
                  format(user_output,
                         "*** Error: In module ~w, constructor(s) ~w\n    \c
                          appear in more than one declaration.\n",
                         [M, DD]
                        ),
                 !,fail
               ),
               true
            ),
                  
          deleteUnwanted(NotFromThisModule, CListWithoutD, CList2),         
	  makeSemicolList(CList2, CSemiCol),
	  renameConsts(CSemiCol, [], Constsrenamed, RenLC, M),
	  makeConstructorList(Constsrenamed, [], CR),
	  addConstsOrigin(CR, CList2, [], [], ConstsWithOrigin),
	  removeConstructors(OldExL, [], Tmp),
	  ownappend(Tmp, ConstsWithOrigin, Tmp2)
       )
    ),
  % rename function signatures and nested data type constructors
  renargs(M, Tmp2, RenLC, Tmp2, NewExL).

getDoubles([],L,K):-
  remove_duplicates(L,K).
getDoubles([A|As], Accu, Result):-
  A=c(N,_,_),
  if(member(A,As),getDoubles(As,[N|Accu],Result),getDoubles(As,Accu,Result)).

deleteUnwanted([], L, L).
deleteUnwanted([A|As], CList, Result):-
  delete(CList, A, NewCList),
  deleteUnwanted(As, NewCList, Result).

renameCompletely(M,[r(Old,New,M)|Rest], RenLC, OldExL,NewExL):-
  ownmember(f(Old,Consts,Prio,Kind,OrigMod,OrigName), OldExL),
  !,
  delete(OldExL, f(Old,Consts,Prio,Kind,OrigMod,OrigName), Tmp),
  ownappend([f(New,Consts,Prio,Kind,OrigMod,OrigName)], Tmp, Tmp2),
  renameCompletely(M,Rest,RenLC,Tmp2,NewExL).

renameCompletely(M,[r(Old,New,M)|Rest],RenLC,OldExL, NewExL):-
  member(d(X=Consts,OrigMod,OrigName), OldExL),   %NOT ownmember
  X=..[Old|Args],
  !,
  delete(OldExL, d(X=Consts,OrigMod,OrigName), Tmp),
  FuncNew=..[New|Args],
  % braucht man hier nicht, weils spaeter eh erledigt wird.
  renameConsts(Consts, [], Constsrenamed, RenLC, M),
  ownappend([d(FuncNew=Constsrenamed,OrigMod,OrigName)], Tmp, Tmp2),
  renameCompletely(M,Rest,RenLC,Tmp2,NewExL).

% for abstract data types.
renameCompletely(M,[r(Old,New,M)|Rest],RenLC,OldExL,NewExL):-
  ownmember(d(Old,OrigMod,OrigName), OldExL),
  !,
  delete(OldExL, d(Old,OrigMod,OrigName), Tmp),
  ownappend([d(New,OrigMod,OrigName)], Tmp, Tmp2),
  renameCompletely(M,Rest,RenLC,Tmp2,NewExL).

renameCompletely(M, [_|T], RenLC, OldExL, NewExL):-
  % the first element is not a renaming statement
  renameCompletely(M, T, RenLC, OldExL, NewExL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renargs(Mod, ExpL, RenLC, OldExL,NewExL)
%
% in d(X=A,...) we possibly have to rename the 
% constructors in A, even if X was not renamed.
% idem in f(F,Signature,_,_) the Signature may 
% have to be renamed.
% This is what is done by renargs. The renamings 
% are stored in RenLC, they have to be done for 
% module Mod (CalledMod), and ExpL is the working list.
%
% renargs is exclusively used by renameCompletely/5.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renargs(_,[],_,L,L).
renargs(M,[f(F,Sig,Prio,Kind,OrigMod,OrigName)|Rest],RenLC,OldExL,NewExL):-
  !,
  renameFunction(Sig, SigRenamed, RenLC, M),
  delete(OldExL, f(F,Sig,Prio,Kind,OrigMod,OrigName), Tmp),
  ownappend([f(F,SigRenamed,Prio,Kind,OrigMod,OrigName)], Tmp, Tmp2),
  renargs(M,Rest,RenLC,Tmp2,NewExL).
  
renargs(M,[d(X=Consts,OrigMod,OrigName)|Rest], RenLC, OldExL, NewExL):-
  !,
  renameConsts(Consts, [], ConstsR, RenLC, M),
  delete(OldExL, d(X=Consts,OrigMod,OrigName), Tmp),
  %format("In Modul ~w wird Consts ~w zu ~w, OrigKonstruktor ~w\n",[M,Consts,ConstsR,X]),
  ownappend([d(X=ConstsR,OrigMod,OrigName)], Tmp, Tmp2),
  renargs(M,Rest,RenLC,Tmp2,NewExL).
renargs(M,[_|Rest], RenLC, OldExL, NewExL):-
  renargs(M,Rest,RenLC,OldExL,NewExL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extractConstructors(ExpList, CLOld, CLNew)
%
% extracts all constructors (terms headed by c(..)) from ExpList.
% The result is returned in CLNew; CLOld is an accu.
%
% exclusively used by renameCompletely
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extractConstructors([],L,L).
extractConstructors([c(E,OrigMod,OrigName)|Es], CLOld, CLNew):-
  !,
  ownappend([c(E,OrigMod,OrigName)], CLOld, CLNew2),
  extractConstructors(Es, CLNew2, CLNew).
extractConstructors([_|Es], CLOld, CLNew):-
  extractConstructors(Es, CLOld, CLNew).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeConstructors(ExpList, CLOld, CLNew)
%
% removes all Constructors (terms headed by 'c') from ExpList
% and returns the result in CLOld. CLNew is the result.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeConstructors([], C, C).
removeConstructors([c(_,_,_)|Es], CLOld, CLNew):-!,
  removeConstructors(Es, CLOld, CLNew).
removeConstructors([E|Es], CLOld, CLNew):-
  ownappend([E], CLOld, Tmp),
  removeConstructors(Es, Tmp, CLNew).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% renamePartially(OldName, NewName, RenList, InMod)
%
% renames an entity called OldName w.r.t. the renaming statements
% in RenList (which is actually the whole import list of the importing
% module). The entity to be renamed is declared in InMod.
%
% renamePartially/4 is exlusively used by makeNewExpL/5.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

renamePartially(OldName, NewName, EL, InMod):-
  ownmember(r(OldName, NewName, InMod), EL),!.
renamePartially(OldName, OldName, _, _). 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildAndCheckImportChains(IL, RootModule, ImpChains)
%
% generates a list of all chains of imports starting by module
% RootModule. "IL" is the global import table and "ImpChains"
% will be the resulting list. This predicate will fail if there
% are cyclic imports (we do not support mutually recursive scopes).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildAndCheckImportChains(IL, RootModule, ImpChains):-
	makeModImportsList(IL, RootModule, Imps),
	buildImportChains(IL, [RootModule], Imps, [], ImpChains).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildImportChains(GlobalImportTable,
%                   CurrentImportList,
%                   LocalImportTable,
%                   OldListOfAllChains,
%                   NewListOfAllChains)
%
% creates a list of chains of imports starting by the first element
% of "CurrentImportList". This predicate will fail if there exists
% a cycle in the import-statements.
%
% Parameters:
%	- GlobalImportTable
%	  ImportTable created by buildImportTable
%       - CurrentImportList
%         one chain of imports starting by the last element of
%         this list
%       - LocalImportTable
%         part of the modules imported by the first element of
%         CurrentImportList. The first element of this list
%         will be the first element of the next incarnation
%         of CurrentImportList.
%       - OldListOfAllChains (accu)
%       - NewListOfAllChains
%         List of all chains of imports built so far
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildImportChains(IL, [SM2|T], [], OldListOfAllChains, NewListOfAllChains):-
  functor(SM2,SM,_),      %SM2 may contain a list of arguments
  makeModImportsList(IL, SM, R),
  if(
	R=[],
	(
	   reverse([SM|T], RevList),
	   ownappend([RevList], OldListOfAllChains, NewListOfAllChains)
	),
        NewListOfAllChains = OldListOfAllChains
    ).

buildImportChains(IL,[StartModule2|RestChain],[H2|SM_ImportList],OLOAC,NLOAC):-
  functor(H2,H,_),                           % H2 and StartModule2 may contain an
  functor(StartModule2,StartModule,_),       % argument list
  % Check for cycles
  if(
	ownmember(H,[StartModule|RestChain]),
	(
	   reverse([StartModule|RestChain], C),
	   ownappend(C, [H], Cycle),
	   interfaceInFile(StartModule, File1),
	   ownappend(A,[H|_],C),!,   %ownappend proceeds from left to right
	   ownlast(Last,A),
	   if(
		Last=[],    %i.e. main was imported
		format(user_error, "\n*** Error: Module 'main' is imported by \c
					module '~w' in file '~w'.\n",
					[StartModule, File1]),
		(
		    interfaceInFile(Last,File2),
		    format(user_error, "\n*** Error: Cyclic import of module.\n\c
				'~w' is imported by '~w' (file ~w) and by '~w' (file ~w).\n\c
				Chain of imports: ~w\n",
				[H, StartModule, File1, Last , File2, Cycle])
		)
	     ),
	   !,fail
	),
	true
    ),
  ownappend([H],[StartModule],Tmp),
  ownappend(Tmp, RestChain, Tmp2),
  makeModImportsList(IL, H, H_Imports),
  buildImportChains(IL, Tmp2, H_Imports, OLOAC, NLOAC2),
  buildImportChains(IL, [StartModule|RestChain], SM_ImportList, NLOAC2, NLOAC).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeModExportsList(GIL, Module, Result)
%
% builds a list of all entities exported by Module. This information
% is extracted from the global import table (remember:
% The Format of the Global Import List is as follows:
%   [(File{1}, FileImpExpList{1}), ..., (File{n}, FileImpExpList{n})],
% where FileImpExpList{i} has the format
%   [(Module{i,1},LOM{i,1},Exp{i,1},Used{i,1}), ..., 
%    (Module{i,m},LOM{i,m},Exp{i,m},Used{i,m})]
% where LOM{i,j} is the list of modules that are imported by Module{i,j},
% Exp{i,m} is the list of entities exported by module {i,j}
% and Used{i,j} specifies whether Module{i,j} really has to be imported 
% or was just ownappended to the list while reading a file.
% The distinction between 'used' and 'unused' in the first two
% clauses is necessary: it is possible that there exist two modules 
% of the same name one of which is "unused".
%
% The result is an ordered set (to be able to apply e.g. a subset-operator).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeModExportsList(GIL, Module, Result):-
  mMEL(GIL, Module, Result).
mMEL([(_,[(Module,_,ExpL,'used')|_])|_], Module, ExpL):-
  !.
mMEL([(File,[(Module,_,_,'unused')|RL])|RL2], Module, Result):-
  mMEL([(File,RL)|RL2], Module, Result),!.
mMEL([],_,_,'error').   %should not happen!
mMEL([(File,[(_,_,_,_)|RL])|RL2], Module, Result):-
  mMEL([(File,RL)|RL2], Module, Result).
mMEL([(_,[])|RL2], Module, Result):-
  mMEL(RL2, Module, Result).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extMIL(GIL, ModList, OldRes, NewRes)
%
% extends the list of imports of all modules in ModList in the 
% following sense:  If a module 'mod' in ModList contains an import 
% statement of the form
%   import m.
% then this is completed to 
%   import m(ExpL)
% where ExpL is the list of all entities declared in the interface 
% of 'mod'.
%
% Parameters: 
%	- GIL
%	  global import table
%	- ModList
%	  list of modules which possibly
%	  have to be completed
%	- OldRes
%	  accu for NewRes
%	- NewRes 
%	  the resulting (completed) list
%
% This predicate is used by makeModImportsList.
%	
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extMIL(_, [], L, L).
extMIL(GIL, [H|ToExt], OldRes, NewRes):-
  if(
       functor(H, _, 0),
       (
	  makeModExportsList(GIL, H, HExports),
	  HNew =.. [H|[HExports]],
	  ownappend(OldRes, [HNew], NR),
	  extMIL(GIL, ToExt, NR, NewRes)
       ),
       (
	  ownappend(OldRes, [H], NR),	  
	  extMIL(GIL, ToExt, NR, NewRes)
       )
     ).


	  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeModImportsList(GIL, Module, Result),
% makeExtendedModImportsList(GIL, Module, Result)
%
% returns in Result all modules imported by "Module" which are
% "used".
% The extended version of this predicate fills in all entities to be
% imported if only the module name is imported
% The distinction between 'used' and 'unused' in the first two
% clauses is necessary: it is possible that there exist two modules 
% of the same name one of which is "unused".
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeModImportsList(GIL, Module, Result):-
  mMIL(GIL, Module, Result).

makeExtendedModImportsList(GIL, Module, Result):-
  mMIL(GIL, Module, Res_unordered),
  extMIL(GIL, Res_unordered, [], NewRes),
  list_to_ord_set(NewRes, Result),
  format("Mod ~w imports ~w\n", [Module, Result]).

mMIL([(_,[(Module,ImpL,_,'used')|_])|_], Module, ImpL):-!.
mMIL([(File,[(Module,_,_,'unused')|RL])|RL2], Module, Result):-
  mMIL([(File,RL)|RL2], Module, Result),!.
mMIL([],_,_,'error').   %should not happen!
mMIL([(File,[(_,_,_,_)|RL])|RL2], Module, Result):-
  mMIL([(File,RL)|RL2], Module, Result).
mMIL([(_,[])|RL2], Module, Result):-
  mMIL(RL2, Module, Result).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeInterfFileList(IL, Result)
%
% returns a list of all interface files used in the project.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeInterfFileList(IL, Result):-
  makeInterfFileList(IL, [], Result).
makeInterfFileList([],L,L).
makeInterfFileList([(File,_)|RL],OldList,NewList):-
  addExtension(File, '.int', FileWithExt),
  makeInterfFileList(RL,[FileWithExt|OldList],NewList).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeModNameList(IL, Result)
%
% extracts all ***used*** module names from the global import table.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeModNameList(IL, Result):-
  makeModNameList(IL, [], Result).
makeModNameList([],L,L).
makeModNameList([(File,[(_,_,_,'unused')|RL])|RL2], OldList, NewList):-
    makeModNameList([(File,RL)|RL2], OldList, NewList).
makeModNameList([(File,[(M,_,_,'used')|RL])|RL2], OldList, NewList):-
  makeModNameList([(File,RL)|RL2], [M|OldList], NewList).
makeModNameList([(_,[])|RL], OldList, NewList):-
  makeModNameList(RL, OldList, NewList).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkForDoubleModNames(IL)
%
% checks whether a module name is used more than once
% If there exist two modules of the same name where only one is "used"
% then the goal succeeds.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkForDoubleModNames(IL):-
  makeModNameList(IL, [], ModList),
  cFDN(ModList).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% cFDN(L)
%
% checks whether there are double entries in a list
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cFDN([]).
cFDN([H|T]):-
  if(
      ownmember(H,T),
      (
	  format(user_error, "\n*** Error: Module '~w' is declared twice.\n", [H]),
	  !,fail 
      ),
      cFDN(T)
    ). 



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildImportTable(ModList, OldGlobalList, NewGlobalList, 
%                  OldChecked, NewChecked)
%
% builds up the global import table. Cycles are not detected but
% ignored (i.e. there will not be any infinite loop).
% Detection of Cycles will be performed in checkForImportCycles(..)
% buildImportTable also reads all exports in the modules and stores them
% in the GlobalImportTable.
%
% Parameters: 
%      - ModList is the current list of modules to be imported (first invocation
%        with the list of modules that main imports),
%      - OldGlobalList is the current global import table (accu),
%      - NewGlobalList is the resulting global import table
%      - OldChecked is the current list of checked modules (accu)
%      - NewChecked is the resulting list of checked modules.
%
% The Format of the Global Import List is as follows:
%   [(File{1}, FileImpExpList{1}), ..., (File{n}, FileImpExpList{n})],
% where FileImpExpList{i} has the format
%   [(Module{i,1},LOM{i,1},Exp{i,1},Used{i,1}), ..., 
%    (Module{i,m},LOM{i,m},Exp{i,m},Used{i,m})]
% where LOM{i,j} is the list of modules that are imported by Module{i,j},
% Exp{i,m} is the list of entities exported by module {i,j}
% and Used{i,j} specifies whether Module{i,j} really has to be imported or was
% just put into the list while reading a file.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildImportTable([],L,L,A,A).
buildImportTable([ModulWL|RestImp],OldGlobalList,NGL,OldChecked,NewChecked):-
  % we are only interested in the names of the importing Modules
  functor(ModulWL, Modul, _),
  if(
       ownmember(Modul,OldChecked),
       %YES: Module already checked	
       buildImportTable(RestImp, OldGlobalList,NGL,OldChecked,NewChecked),
       %NO: check Module	
       (
	 if(
	      interfaceInFile(Modul, File),
	      !,   %to avoid too nested if-structures!
	      (
		 format(user_error, "\n*** Error: There is no entry in the file\c
				     table for module '~w'.\n",[Modul]),
		 !,fail
	      )
	   ),
	 if(
	      ownmember((File,ModAndImpList),OldGlobalList),
	      %YES: File already read
	      if(
		   ownmember((Modul,IL,_,_),ModAndImpList),
		   (
		      ownappend([Modul], OldChecked, N),
		      buildImportTable(IL, OldGlobalList, NGL2,
					N,NewCheck2),
		      markUsed(File, Modul, NGL2,NGL3),
		      buildImportTable(RestImp, NGL3, NGL, NewCheck2,NewChecked)	
		   ),
		   (
		      format(user_error, "\n*** Error: File '~w' should contain \c
					  module '~w'.\n", [File, Modul]),
	              !,fail
		   )

		),
	      %NO: read File
	      (
		collectImports(File, (File,NewList),interface),
		if(
		     ownmember((Modul,NeueImps,_), NewList),
		     % YES: file contains the specified module
		     (
			addTag(NewList, [], A),
			ownappend([(File,A)], OldGlobalList,NL),	    
			markUsed(File,Modul,NL,B),
			ownappend([Modul], OldChecked, N),
			buildImportTable(NeueImps, B, NGL2, N, NewChecked2),
			buildImportTable(RestImp, NGL2, NGL, NewChecked2, NewChecked)
		     ),
	   	     (
		        format(user_error, "\n*** Error: File '~w' should contain \c
					    module '~w'.\n", [File, Modul]),
	                !,fail
		     )	
		  )
	       )
	    )
	)
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% markUsed(File, Module, Table, ResultingTable)
%
% mark the specified module (declared in file) as "used". A module is
% called "used" if it is imported by another module. When a header file
% is read, all declared modules in that header file are read and
% internally stored in order not to read a file twice.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

markUsed(File, Module, Table, ResultingTable):-
	ownappend(HeadList, [(File, FileImports)|RestList1], Table),
	ownappend(A, [(Module, ModImports, ModExports, _)|RestList2], FileImports),
	ownappend(A, [(Module, ModImports, ModExports, 'used')], NewA),
	ownappend(NewA, RestList2, NewFileImports),
	ownappend(HeadList, [(File,NewFileImports)], C),
	ownappend(C,RestList1,ResultingTable).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addTag(ModulAndImpList, OldList, NewList)
%
% ModuleAndImpList is of the form 
%	[(Module{1}, MIL{1}), ..., (Module{n}, MIL{n})]
% where MIL{i} is the list of modules imported by Module{i}.
% addTag adds a flag "unused" to this list which can be overwritten by
% buildImportTable(..).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addTag([],L,L).
addTag([(Modul,ImpList,ExpList)|RL], OldList, NewList):-
	ownappend(OldList, [(Modul, ImpList, ExpList, 'unused')], TmpList),
	addTag(RL, TmpList, NewList).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% addExtension(Name, Ext, NameExt)
%
% adds the extension Ext to Name and returns NameExt.
% this predicate is used to append file suffixes like .fl or .int.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

addExtension(Name,Ext,NameExt) :-
	name(Name,NameL),
	name(Ext,ExtL),
	ownappend(NameL,ExtL,NameExtL),
	name(NameExt,NameExtL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% collectImports(Prog, (Prog, ToBeImported), ImplInt)
%
% collects all import-statements in a file and returns a list of these 
% imports together with the name of the module in which they appear.
% The result is a pair
%  (File, [(Mod1,[i11,i12,...]), (Mod2,[i21,i22,...]), ...])
% where Mod{j} are the modules appearing in that file, and
%       i{j,x} are the modules imported by Mod{j}.
% ImplInt = 'interface' if interfaces are to be read,
% otherwise implementations will be read.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

collectImports(Prog, (Prog,ToBeImported), ImplInt):-
  if(
       (ImplInt==interface, Prog==prelude),
       (
	  on_exception(
                          _,
			  (
			      prelpath(PP),
			      addExtension(PP,'.int', FN),
			      see(FN)
			  ),
		          (format(user_error, "\n*** Error: prelude's \c
                                    interface does not exist.\n",[]),
                           fail
                          )
                      )
       ),
       true
    ),       
  if(
       ImplInt==interface,
       (
  	  if(
	       Prog==prelude,
	       prelpath(PFile),
	       PFile=Prog
            ),	  
          addExtension(PFile, '.fl', ImplFile),
          on_exception(
                         _,
                         see(ImplFile),
		         (format(user_error, "\n*** Error: implementation \c
                                   file '~w' does not exist.\n",[ImplFile]),
                          fail
                         )
                       ),
          seen,
          file_property(ImplFile, mod_time(ImplTime)),
          addExtension(PFile, '.int', IntfFile),
	  on_exception(
                          _,
			  see(IntfFile),
			  GenInt=doIt
                      ),
          if(
               var(GenInt),       %impl. exists
               (
                  file_property(IntfFile, mod_time(IntfTime)),
                  if(
                       (ImplTime>IntfTime,      %implem. is newer
                        Prog \== prelude        % NOT for the prelude
                       ),
                       (
                           format(user_output,
                                  "interface file '~w' is older than implementation ... ignoring it.\n",
                                   [IntfFile]
                                  ),
                           addExtension(IntfFile,'.bak',Backup),
                           rename_file(IntfFile, Backup),
                           GenInt=doIt
                       ),
                       GenInt=leaveIt
                    ),
                  seen
               ),
               true    %GenInt==doIt
            ),

          if(   
               GenInt==doIt,
               (
		   asserta(noInterface(Prog)),
                   Command=generateInterface,
                   see(ImplFile)
                ),
                (
                   see(IntfFile),
                   Command=ImplInt   %interface
                )
             )
       ),
       (   % ImplInt \= interface
  	  if(
	       Prog==prelude,
	       prelpath(PFile2),
	       PFile2=Prog
            ),	  
           addExtension(PFile2, '.fl', File),
           on_exception(  
                           _, 
		           see(File),
		           (format(user_error, "\n*** Error: implementation \c
                                   file '~w' does not exist.\n",[File]),
	                    fail
		           )
                       )
       )
    ),
  if(
       var(Command),
       Command=ImplInt,
       if(
            GenInt==doIt,
            File=ImplFile,
            File=IntfFile
         )
    ),
  findImports([], ToBeImported, [], File, Command),
  seen,
  !.



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeConstructorList(CL, Old, New)
%
% builds a list of the form [c(x{1}), ..., c(x{n})] if CL is of the
% form x{1};x{2};...;x{n}. As we cannot distinguish between
% parameters of constructors (types!) and constructors, we delete
% types!
% Old is an accumulator.
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeConstructorList((A;B), Old, New):-
  !,
  getSubterms(A, Subterms),
  % if we do not remove types, then we'll get an
  % multiple decl. error if we have e.g.
  %  data d1=c1(int).
  %  data d2=c2(int).
  removeTypes(Subterms, [], NewSubterms),
  map(addC,NewSubterms,[],NewCList),
  ownappend(Old,NewCList, Tmp),
  makeConstructorList(B, Tmp, New).
makeConstructorList(A,Old,New):-
  !,
  getSubterms(A, Subterms),
  removeTypes(Subterms, [], NewSubterms),
  map(addC,NewSubterms,[],NewCList),
  ownappend(Old, NewCList, New1),
  remove_duplicates(New1, New).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeTopLevelConstructorList(CL, Old, New)
%
% builds a list of the form [c(x{1}), ..., c(x{n})] if CL is of the
% form x{1};x{2};...;x{n}. As we cannot distinguish between
% parameters of constructors (types!) and constructors, we delete
% types!
% Different to makeConstructorList, here only toplevel-terms are
% stored (therefore types cannot occur).
% Old is an accumulator.
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeTopLevelConstructorList((A;B), Old, New):-
  !,
  functor(A,AFct,_),
  % if we do not remove types, then we'll get an
  % multiple decl. error if we have e.g.
  %  data d1=c1(int).
  %  data d2=c2(int).
  makeTopLevelConstructorList(B, [c(AFct)|Old], New).

makeTopLevelConstructorList(A,Old,[c(AFct)|Old]):-
  functor(A,AFct,_).


makeUnaryConstructorList((A;B), Exports, Old, New):-
  !,
  functor(A,_,Arity),
  if(
       (Arity==0, member(c(A,_,_), Exports)),
       Tmp=[c(A)|Old],
       Tmp=Old
    ),
  makeUnaryConstructorList(B, Exports, Tmp, New).

makeUnaryConstructorList(A, Exports, Old, [c(A)|Old]):-
  functor(A, _, 0),
  member(c(A,_,_), Exports),
  !.

makeUnaryConstructorList(_, _, Old, Old).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeTypes(SubtermList, Accu, Result)
%
% removes global Types from SubtermList and
% stores the result in Result.
%
% removeTypes/3 is exclusively used by 
%  makeConstructorList/3.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeTypes([], L, L).
removeTypes([S|Ss], Accu, Result):-
  if(
       globalType(S),
       removeTypes(Ss, Accu, Result),
       removeTypes(Ss, [S|Accu], Result)
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% map(Function, List, Accu, Result)
%
% applies Function to every element of List and
% returns the result in Result.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

map(X,[E|Es],Accu,Res):-
     T=..[X,E,ENew],
     call(T),
     append(Accu,[ENew],Tmp),
     map(X,Es,Tmp,Res).
map(_,[],L,L).
addC(X,c(X)).
addCdummy(X,c(X,dummy,dummy)).
delC(c(X),X):-!.
delC(X,X).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeSemicolList(Consts, CSem)
%
% transforms a list [c(c1,_,_),c(c2,_,_),...] into c1;c2;...
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

makeSemicolList([c(C,_,_)|[]], C):-!.
makeSemicolList([c(C,_,_)|Cs], (C;CC)):-
  makeSemicolList(Cs, CC).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildExport(Exp, Mod, Result)
%
% 'data' declarations may contain lists of data types.
% Exp is checked for such lists; Result consists of a 
% list containing all datas in the form d(name,mod,name)
% where mod and the 2nd denote the original occurings of the entity.
% If a data declaration is of the form X=A, then all constructors in A
% are added, too (c(ConstName, Mod, ConstName).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildExport(d(Exp), Mod, Export):-
  !,
  if(
       functor(Exp, '.', _),   %Exp is a list
       bDatEx(Exp, Mod, [], Export),
       bDatEx([Exp], Mod, [], Export)
    ).

buildExport(X, _, [X]).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% bDatEx/4 
%
% build lists of data with original
% name and original module. If necessary, the
% data constructors are added, too.
%
% This predicate is exclusively used by
% buildExport/3. (and rNED - removing not
% exported decls)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bDatEx([], _, L, L).
bDatEx([Exp|Es], Mod, Old, New):-
  if(
       Exp=(D=A),	%constructors have to be stored, too
       (
	 makeConstructorList(A, [], CList),
	 addConstsOrigin(CList, Mod, [], NewCL),
	 ownappend([d(D=A, Mod, D)], NewCL, Export)
       ),
       Export=[d(Exp, Mod, Exp)]
    ),
  ownappend(Old, Export, Tmp),
  bDatEx(Es,Mod,Tmp,New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
% findImports(Is, Result, Mod, File, ImplInt)
% 
% returns in Result a list of all modules that are anywhere imported 
% in file File. Mod is the name of the current module, for the
% format of Result cf. collectImports. ImplInt is 'interface'
% when interfaces are read; otherwise implementations will be read.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

findImports(Is, Result, Mod, File, ImplInt):-
  on_exception(
                 ErrorMsg,
                 read(Line),
	         (
	             format(user_error,
			    "\n*** In file \c
			     '~w', module '~w':\n",
			    [File, Mod]),
                     print_error(ErrorMsg),
		     !,
                     fail			
                 ) 
	      ),
  if(
       ImplInt=interface,
       readInterface(Line,ImportOrExport,Mod,NewMod,File),
       if(
            ImplInt=implementation,
	    readImplementation(Line,ImportOrExport,Mod,NewMod,File),
	    readImplAndGenIntrf(Line,ImportOrExport,Mod,NewMod,File)
         )
    ),
  if(
       ImportOrExport=(ibody,Exp),
       (
	  Import=[],
          % necessary for the following lines. These are local definitions!
          if(Exp=o(Name, Prio, ixl, M, Name), op(Prio, yfx, Name), true),
          if(Exp=o(Name, Prio, ix, M, Name), op(Prio, xfx, Name), true),
          if(Exp=o(Name, Prio, ixr, M, Name), op(Prio, xfy, Name), true),
	  buildExport(Exp,NewMod,Export)
       ),
       (
          if(
               ImportOrExport=(impRen, Ims, Res),
               (
                  Import=Ims,
                  Export=Res
               ),
               (
          	  Import=ImportOrExport,
                  Export=[]
               )
            )
       )
    ),
  if(
       functor(Import,'.',_),    %impdecl is a list
       Imp2=Import,
       if(
	    functor(Import,[],0),
	    Imp2=Import,
	    Imp2=[Import]
	 )
    ),
  if(
       ownmember((Mod,ModImports,ModExports), Is),
       (
	  ownappend(Imp2, ModImports, NewImportList),
	  ownappend(ModExports, Export, NewExportList),
	  delete(Is, (Mod,ModImports,ModExports), RL),
	  ownappend(RL, [(Mod,NewImportList,NewExportList)], R)
       ),
       ownappend(Is, [(NewMod,Imp2,Export)], R)
    ),
  if(
       Line==end_of_file,
       %ownappend(Result,[([],[],[])],R), %([],[]) added by end_of_file with 'endmodule' statement
       if(
            ImplInt==generateInterface,
            (
               % double function declarations (of type 'dontcare') have to be removed
	       % if there is an explicit type declaration F::T, then all other
	       % 'dontcare' types for this function have to be removed.
	       append(Left, [(Mod, ModImps, ModExps)|Right], R),
 	       remove_duplicates(ModExps, MExp2),
	       removeDoubleTypeDecls(MExp2, [], NMExps),
               % we need the implementatiosn renamings for the check!!!!
               findall(r(_A,_B,_C), member(r(_A,_B,_C), NMExps), RRRR),
	       removeNotExportedDecls(NMExps, _NewModExps, AllImports),
               append(_NewModExps,RRRR,NewModExps),
               % store the imports for later check and for writing
               % AllImports==[] if entites are exported but no modules
               % AllImports==[module] if only modules are exported
 	       % Now (26.7.97): If only modules appear in the header,
	       % then only modules are exported!
               asserta(modExportsMod(Mod,AllImports)),
	       append(Left, [(Mod, ModImps, NewModExps)|Right], Result)
            ),
            Result=R
         ),
       findImports(R,Result,NewMod,File, ImplInt)
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeNotExportedDecls(Exps, NewEntities, AllImports)
%
% If there are export statements in an implementation (i.e. e(..) in
% 'Exps'), then we extract these and discard not-exported entities.
% If there is no export statement, then the interface exports 
% everything. 
% AllImports is a list of the module-exports in the module's header.
% The result is NewEntities.
%
% removeNotExportedDecls/2 is exclusively used by
% findImports/5.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% module m1((module m01), (module m02), ...)
% means: export all entities in m1;
%        in the interface: import m01, m02, ...

removeNotExportedDecls(Exps,NewEntities,AllImports):-
  member(e(_),Exps),
  !,
  buildOneExportList(Exps, [], WithoutExps, [], Exports),
  rNED(Exports, WithoutExps, [], NewEntities),
  findall(Imp,member(module(Imp),Exports),AllImports).


%removeNotExportedDecls(Exps,NewEntities,AllImports):-
%  member(e(EE),Exps),
%  !,
%  findall((module M), member((module M), EE), ExpMod),
%  if(
%        ExpMod==EE,            %i.e. only modules are exported
%        (
%           NewEntities=Exps,   %then export everything in the module
%           AllImports=EE       %and the stated modules
%        ),
%        (
%           buildOneExportList(Exps, [], WithoutExps, [], Exports),
%           rNED(Exports, WithoutExps, [], NewEntities),
%           findall(Imp,member(module(Imp),Exports),AllImports)
%        )
%     ).

% no export declaration means: export everything
% "everything" would be better than "module", but "module" is an 
% reserved name.
removeNotExportedDecls(Exps, Exps, [module]).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% buildOneExportList(Entities, Accu1, WithoutExps, Accu2, Exports)
%
% merges the e(..)-entries in Entities into one, which is stored 
% in Exports. WithoutExps is the entity list 'Entities' without
% the e(..) entries.
%
% buildOneExportList/5 is exclusively used by removeNotExportedDecls/2.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

buildOneExportList([], L1, L1, L2, L2).
buildOneExportList([e(E)|Rest], Accu1, WithoutExps, Accu2, Exports):-
  !,
  % E is a list
  append(E, Accu2, NewAccu2),
  buildOneExportList(Rest, Accu1, WithoutExps, NewAccu2, Exports).
buildOneExportList([E|Rest], Accu1, WithoutExps, Accu2, Exports):-
  buildOneExportList(Rest, [E|Accu1], WithoutExps, Accu2, Exports).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% rNED(Exports, Entities, Accu, NewEntities)
%
% extracts the exports in Exports from Entities and stores the
% result in NewEntities. Constructors will be copied to NewEntities
% if the data declaration has '..' as argument.
% 
% rNED/4 is exclusively used by removeNotExportedDecls/2.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  renamings can be ignored, as they are only done for *imported*
% entities
rNED([], _, L, L).

rNED([(module _)|Es], Entities, Accu, NewEntities):-
  !,
  rNED(Es, Entities, Accu, NewEntities).
% so far we did not import any entity !
rNED([E|Es], Entities, Accu, NewEntities):-
  functor(E,E,0),       %export without constructors
  member(d(ParamName=_,OM,_), Entities),
  functor(ParamName, E, _),   %ignore parametrisation
  !,
  rNED(Es, Entities, [d(E,OM,E)|Accu], NewEntities).

rNED([E|Es], Entities, Accu, NewEntities):-
  E=..[EntName,..],     % export with all constructors
  member(d(ParamName=Consts,OM,_), Entities),
  functor(ParamName, EntName, _),      %ignore parametrisation
  !,
  % extract constructors
  bDatEx([(ParamName=Consts)], OM, [], DatAndConstList),
  append(DatAndConstList, Accu, NewAccu),
  rNED(Es, Entities, NewAccu, NewEntities).

rNED([E|Es], Entities, Accu, NewEntities):-
  E=..[EntName|ConstsToExport],     % partial export with specified constructors
  member(d(ParamName=Consts,OM,_), Entities),
  functor(ParamName, EntName, _),      %ignore parametrisation
  !,
  % delete not exported constructors
  remNotExpConsts(Consts, ConstsToExport, [], ExportedConsts, OM),
  if(
       ExportedConsts==[],
       (
          NewAccu=[d(ParamName,OM,ParamName)|Accu],
          format(user_output,
                 "+++ Warning: Module '~w' exports unknown entities ~w \c
                  ... ignoring.\n", [OM, ConstsToExport])
       ), 
       (
          bDatEx([(ParamName=ExportedConsts)], OM, [], DatAndConstList),
          append(DatAndConstList, Accu, NewAccu)
       )
    ),
  rNED(Es, Entities, NewAccu, NewEntities).

rNED([E|Es], Entities, Accu, NewEntities):-
  member(f(E,T,OM,ON), Entities),
  !,
  if(
       member(o(E,P,K,OM,ON),Entities),
       rNED(Es, Entities, [o(E,P,K,OM,ON),f(E,T,OM,ON)|Accu], NewEntities),
       rNED(Es, Entities, [f(E,T,OM,ON)|Accu], NewEntities)
    ).

rNED([E|Es], Entities, Accu, NewEntities):-
  member(o(E,P,K,OM,ON), Entities),
  !,
  if(
       member(f(E,T,OM,ON),Entities),
       rNED(Es, Entities, [o(E,P,K,OM,ON),f(E,T,OM,ON)|Accu], NewEntities),
       rNED(Es, Entities, [f(E,T,OM,ON)|Accu], NewEntities)
    ).

rNED([E|Es], Entities, Accu, NewEntities):-
  member(c(E,OM,_), Entities),
  !,
  format(user_error,
         "+++ Warning: Module '~w' explicitely exports \c
          constructor '~w' \c
          ... ignoring.\n", [OM, E]),
  rNED(Es, Entities, Accu, NewEntities).

rNED([E|Es], Entities, Accu, NewEntities):-
  % get the module's name
  (member(f(_,_,OM,_),Entities);
   member(o(_,_,_,OM,_),Entities);
   member(d(_=_,OM,_), Entities);
   member(c(_,OM,_), Entities)
  ),
  !,
  format(user_error,
         "+++ Warning: Module '~w' exports unknown entity '~w' \c
          ... ignoring.\n", [OM, E]),
  rNED(Es, Entities, Accu, NewEntities).

rNED([E|Es], Entities, Accu, NewEntities):-
  format(user_error,
         "+++ Warning: empty module exports unknown entity '~w' \c
          ... ignoring.\n", [E]),
  rNED(Es, Entities, Accu, NewEntities).
  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% remNotExpConsts(ConstList, ConstsToExport, Accu, Result, InModule)
%
% deletes all constructors in a list c1;c2;...;cn that are not
% in ConstsToExport. The result is stored in Result.
% InModule is for a possible error message.
%
% remNotExpConsts/5 is exclusively used by rNED/4.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

remNotExpConsts((C;Cs), ConstsToExport, Accu, Result, Module):-
  !,
  functor(C, CFr, _),
  if(
       member(CFr, ConstsToExport),
       (
          delete(ConstsToExport, CFr, NewCTE),
          remNotExpConsts(Cs, NewCTE, [c(C, dummy,dummy)|Accu], Result, Module)
       ),
       remNotExpConsts(Cs, ConstsToExport, Accu, Result, Module)
    ).
remNotExpConsts(C, ConstsToExport, Accu, Result, Module):-
  functor(C, CFr, _),
  if(
       member(CFr, ConstsToExport),
       (
           delete(ConstsToExport, CFr, NewCTE),
           if(
                NewCTE==[],
                true,
                format(user_output,
                       "+++ Warning: Module '~w' exports unknown entities ~w \c
                        ... ignoring.\n", [Module, NewCTE])
             ),
             makeSemicolList([c(C, dummy,dummy)|Accu], Result)
       ),
       if(
            Accu==[],      %undeclared consts were exported
            Result=[],
            makeSemicolList(Accu, Result)
         )
    ).
  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeDoubleTypeDecls(EntityList, Accu, Result)
%
% Result is a copy of EntityList with one difference: if EntityList 
% contains an f(Name, Type, OrigMod, OrigName) entry AND an
% f(Name, dontcare, OrigMod, OrigName) entry, then the latter is
% removed. Hence explicit type declarations have priority.
%
% removeDoubleTypeDecls/3 is exclusively used by findImports/5.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeDoubleTypeDecls([], L, L).
removeDoubleTypeDecls([f(Name, dontcare, OM, ON)|Rest], Accu, Result):-
  !,
  if(
       (member(f(Name, _, OM, ON), Rest); member(f(Name, _, OM, ON), Accu)),
       (!, removeDoubleTypeDecls(Rest, Accu, Result)),
       (!, removeDoubleTypeDecls(Rest, [f(Name, dontcare, OM, ON)|Accu], Result))
    ),
  !.

removeDoubleTypeDecls([E|Rest], Accu, Result):-
  removeDoubleTypeDecls(Rest, [E|Accu], Result).



  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
%% routines for checking the consistency of the global import table
%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkDoubleRenamings/1, /2,
% cDbRn/2
%
% checks if there are renamings to more than one name or if one
% entity is renamed more than once.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkDoubleRenamings(GIL):-
    makeModNameList(GIL, ML),
    checkDoubleRenamings(ML, GIL).
checkDoubleRenamings([],_).
checkDoubleRenamings([M|Ms],GIL):-
  makeModExportsList(GIL, M, Exps),
  cDbRn(Exps, M),
  checkDoubleRenamings(Ms,GIL).
  

cDbRn(Exps, Mod):-
  member(r(From,To,InMod), Exps),
  delete(Exps, r(From,To,InMod),ExpsTmp),
  member(r(From,_,InMod), ExpsTmp),
  format(user_error, "\n*** Error: In module '~w', '~w' is renamed more \c
			than once.\n",[Mod, From]),
  !,
  fail.
cDbRn(Exps, Mod):-
  member(r(From,To,InMod), Exps),
  delete(Exps, r(From,To,InMod), ExpsTmp),
  member(r(_,To,_), ExpsTmp),
  format(user_error, "\n*** Error: In module '~w', there is more than \c
			one entitity renamed to '~w'.\n",[Mod, To]),
  !,
  fail.
cDbRn(_,_).   %non-determinism!



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkIntRenamings(GIL)
%
% checks if entities to be renamed are imported, if they exist in
% in the specified module and if the specified module exists.
% GIL is the global import table. We only look at interfaces.
%
% checkIntRenamings is an interface for checkRens/2.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkIntRenamings(GIL):-
  makeModNameList(GIL, ML),
  checkRens(ML, GIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkRens(ModList, GIL)
%
% cf. checkIntRenamings. Interface for chR/3.
% 
% checkRens/2 is exclusively used by checkRens.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkRens([], _).
checkRens([M|Ms], GIL):-
  makeModExportsList(GIL, M, Exps),
  chR(Exps, M,GIL),
  checkRens(Ms, GIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% chR(ImpList, Mod, GIL)
%
% checks if the renamings occurring in ImpList w.r.t. entities in
% Mod are correct (cf. checkIntRenamings).
%
% chR/3 is excusively used by checkRens/2.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

chR([],_,_).
chR([r(From, To, Mod)|Rs], M, GIL):-
  !,
  makeModImportsList(GIL, M, Imps),
  if( 
       (member(IM, Imps), IM =..[Mod|_]),
       true,
       (
	  format(user_error, "\n*** Error: Module '~w' renames '~w' in \c
			module '~w', but does not import this module. \n",
			[M, From, Mod]),
	   !,fail
       )
    ),
  % look if the imported entity is in the export list of the exporting module
  makeModExportsList(GIL, Mod, Exps),
  if(
      (
       (member(d(X=_,_,_), Exps), X=..[From|_]);
       (member(d(From,_,_), Exps));
       (member(c(Y,_,_), Exps), Y=..[From|_]);
       (member(f(From,_,_,_,_,_), Exps))
      ),
      chR(Rs, M, GIL),
      (
	 format(user_error, "\n*** Error: Module '~w' renames '~w' in module '~w'\n",
		[M, From, Mod]),
	 !,fail
      )
     ),
  % look if the imported entity has been renamed and is store in the
  % export list of the current module. This is necessary because there
  % are implicit imports of constructors which cannot be found in the
  % export table.
  makeModExportsList(GIL, M, Exps2),
  if(
      (
       (member(d(X2=_,_,_), Exps2), X2=..[To|_]);
       (member(d(To,_,_), Exps2));
       (member(c(Y2,_,_), Exps2), Y2=..[To|_]);
       (member(f(To,_,_,_,_,_), Exps2))
      ),
      chR(Rs, M, GIL),
      (
	 format(user_error, "\n*** Error: Module '~w' renames '~w' in \c
		module '~w', but does not import this entity.\n",
		[M, From, Mod]),
	 !,fail
      )
     ).
chR([_|Rs],M,GIL):-
  chR(Rs,M,GIL).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkImpExp(GIL)	/1
%
% interface for checkImpExp/3. GIL is the global import table.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkImpExp(GIL):-
  makeModNameList(GIL, [M1|MNameL]),   %check for all modules
  makeModImportsList(GIL, M1, M1Imp),
  checkFuncSigs([M1|MNameL], GIL),
  checkImpExp(GIL, [M1|MNameL], M1Imp).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkImpExp(GIL, ModList, ImpList)   /3
%
% checks if any imported entity is also exported in the specified
% module.
%
% Parameters:
%	- GIL
%	  is the global import table
%	- ModList
%	  is the list of importing modules not yet checked
%	- ImpList is a list containing all the entities
%	  imported by the first element of ModList
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The first clause is not only the end of the recursion but it also 
% subsumes the case of complete module imports, i.e. if there
% are statements of the form 
%  import mod.
% which means that the whole module has to be imported. It is
% clear that in this case we need not to check the relationship 
% between imports and exports.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkImpExp(_, [_|[]], []):-!.
checkImpExp(GIL, [M|[]], [MI1|MImp]):-
  MI1 =.. [ModName|ImportsTmp],
  if(
       ImportsTmp=[],
       Imports=[],
       (
	  ImportsTmp=..[_,A,_],
	  if(
	       is_list(A),
	       [Imports]=ImportsTmp,
	       Imports=ImportsTmp
	    )
       )
    ),
  makeModExportsList(GIL, ModName, Exports),
  %format("checking imports ~w against exports ~w\n", [Imports, Exports]),
  %flush_output,
  impInExp(Imports,Exports, M, ModName),
  checkImpExp(GIL, [M], MImp),
  !.

checkImpExp(GIL, [_|RL], []):-
  % the import table of module M has been checked; proceed to the next
  % element in the list of modules.
  RL=[H|_],          % 2nd parameter contains at least 2 elements
  makeModImportsList(GIL, H, HImp),
  checkImpExp(GIL, RL, HImp).

checkImpExp(GIL, [M|RL], [MI1|MImp]):-
  % M imports MI1=ModName([Imports])
  MI1 =.. [ModName|ImportsTmp],
  if(
       ImportsTmp=[],
       Imports=[],
       (
	  ImportsTmp=..[_,A,_],
	  if(
	       is_list(A),
	       [Imports]=ImportsTmp,
	       Imports=ImportsTmp
	    )
       )
    ),

  % check if the entities imported by M from ModName (which are
  % stored in Imports) are also exported by ModName 
  makeModExportsList(GIL, ModName, Exports),
  %format("checking imports ~w against exports ~w\n", [Imports, Exports]),
  impInExp(Imports, Exports, M, ModName),
  checkImpExp(GIL, [M|RL], MImp).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% impInExp(Imports, Exports, ImportingModule, ExportingModule)
%
% checks if a list of entities, Imports, is a subset of a list Exports.
% ImportingModule and ExportingModule are needed for the error
% exception.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

impInExp([],_,_,_):-!.

impInExp([Imp1|RestImp], ExpL, ImportingModule, ExportingModule):-
  if( 
       (  % no cut (nondet!)
	  member(f(Imp1,_,_,_,_,_), ExpL); 
	  member(d(Imp1,_,_), ExpL);
	  (member(c(X1,_,_), ExpL),X1=..[Imp1|_]);
	  % for the next statement we need a priority of ';' superior to that
	  % of '=' (otherwise the following statement will fail).
	  % priority of :: superior to ->
	  (member(d((X2=_),_,_), ExpL), X2=..[Imp1|_]) 
       ),
       impInExp(RestImp, ExpL, ImportingModule, ExportingModule),
       (
	  format(user_error, "\n*** Error: Module '~w' imports '~w' \c
			from module '~w'.\n",
		 [ImportingModule,Imp1,ExportingModule]),
	  !,fail
       )
     ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkForDoubleEntities(GIL)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

checkForDoubleEntities(GIL):-
  makeModNameList(GIL, ML),
  wGl(GIL, ML, _, Error),
  if(Error=fehler,fail,true),
  warnDoubleReferrings(GIL, ML).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% wGL(GIL, ModList, ErrAccu, Error)
%
% checks if there are entites in GIL (precisely:
% in one module's export list) that are multiply
% declared
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

wGl(_,[], X, okay):- var(X), !.
wGl(_,[], fehler, fehler).
wGl(GIL, [M|Ms], Err, Error):-
  makeModExportsList(GIL, M, MExps),
  makeEntityListWithoutConstructors(MExps,[],EntL),
  extractDoubles(EntL, [], Doubles),
  if(
       Doubles=[],
       wGl(GIL, Ms, Err, Error),
       (
         format(user_error, "\n*** Error: Multiple declaration of ~w \c
                                        in module '~w'\n", [Doubles,M]),
	 %printGIL(GIL),
         !,
	 wGl(GIL, Ms, fehler, Error),fail
       )
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% extractDoubles(L, Accu, Result)
%
% stores all names that appear more than once
% in L in Result.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

extractDoubles([], L,L).
extractDoubles([X|Xs], Old, New):-
  if(
       ownmember(X, Xs),
       (
	  delete(Xs,X,NewXs),
	  ownappend([X], Old, Tmp),
	  extractDoubles(NewXs, Tmp, New)
       ),
       extractDoubles(Xs, Old, New)
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% makeEntityList(ExpL, Accu, Result)
%
% extract the entities' names, i.e. stores X
% in Result if one of the following elements
% is in ExpL:
% d(X=_,_,_), d(X,_,_), c(X,_,_), f(X,_,_,_,_,_),
%
%
% operators may be declared as operators.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
       
makeEntityList([],L,L).
makeEntityList([d((L=_),_,_)|Es], Old, New):-
  !,
  L=..[Top|_],
  makeEntityList(Es, [Top|Old], New).
makeEntityList([d(L,_,_)|Es], Old, New):-
  L=..[Top|_],
  makeEntityList(Es, [Top|Old], New).
makeEntityList([o(_,_,_,_,_)|Es], Old, New):-
%  ownappend([L], Old, Tmp),
  Tmp=Old,
  makeEntityList(Es, Tmp, New).
makeEntityList([c(L,_,_)|Es], Old, New):-
  L=..[Top|_],
  ownappend([Top], Old, Tmp),
  makeEntityList(Es, Tmp, New).
makeEntityList([f(L,_,_,_,_,_)|Es], Old, New):-
  ownappend([L], Old, Tmp),
  makeEntityList(Es, Tmp, New).
makeEntityList([r(_,_,_)|Es], Old, New):-
  makeEntityList(Es, Old, New).


makeEntityListWithoutConstructors([],L,L).
makeEntityListWithoutConstructors([d((L=_),_,_)|Es], Old, New):-
  !,
  L=..[Top|_],
  makeEntityListWithoutConstructors(Es, [Top|Old], New).
makeEntityListWithoutConstructors([d(L,_,_)|Es], Old, New):-
  L=..[Top|_],
  makeEntityListWithoutConstructors(Es, [Top|Old], New).
makeEntityListWithoutConstructors([o(_,_,_,_,_)|Es], Old, New):-
%  ownappend([L], Old, Tmp),
  Tmp=Old,
  makeEntityListWithoutConstructors(Es, Tmp, New).
makeEntityListWithoutConstructors([c(_,_,_)|Es], Old, New):-
  makeEntityListWithoutConstructors(Es, Old, New).
makeEntityListWithoutConstructors([f(L,_,_,_,_,_)|Es], Old, New):-
  ownappend([L], Old, Tmp),
  makeEntityListWithoutConstructors(Es, Tmp, New).
makeEntityListWithoutConstructors([r(_,_,_)|Es], Old, New):-
  makeEntityListWithoutConstructors(Es, Old, New).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% warnDoubleReferrings(Mod,ExpL)
%
% warns if there are entities in 'Mod''s ExportList that are 
% referred to more than once.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

warnDoubleReferrings(_,[]).
warnDoubleReferrings(GIL, [M|Ms]):-
  makeModExportsList(GIL, M, MExps),
  if(
       setof((OrMod,OrName), wDR(MExps,(OrMod,OrName)), Doubles),
       (format(user_output, "+++ Warning: In module '~w', there is more \c
	      than one reference to:\n        ",
                      [M]),
        printList(Doubles,8,8,78)),
       true
    ),
  warnDoubleReferrings(GIL, Ms).
  
wDR(ExpL,(ON, OrM)):-
  member(E, ExpL),
  E=..[F|_],
  if(
       F=f,
       (arg(5,E,OM),arg(6,E,ON)),
       if(
	     F=o,
	     (arg(4,E,OM), arg(5,E,ON)),
             (arg(2,E,OM),arg(3,E,ON))
	 )
    ),
  delete(ExpL, E, Tmp),
  member(EE, Tmp),
  EE=..[FF|_],
  if(
       FF=f,
       (arg(5,EE,OM),arg(6,EE,ON)),
       if(
	    FF=o,
	    (arg(4,EE,OM), arg(5,EE,ON)),	
	    (arg(2,EE,OM),arg(3,EE,ON))
	 )
    ),
  name(' originally declared in ', N1),
  name(OM, N2),
  ownappend(N1, N2, N3),
  name(OrM, N3).
               
      
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% checkFuncSigs(ModList, GIL)
%
% checks if all types appearing in the type signature of a function
% are also exported by the current module.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
checkFuncSigs(_,_):-!.     %for the moment, let's forget it!!!
checkFuncSigs(ModL, GIL):-
  makeGlobalTypeList(GTL),
  setof(Err, cFS(GIL, ModL, GTL, Err), Errors),
  delete(Errors, no, NewErr),
  if(
       NewErr=[],
       true,
       (
          printList(NewErr, 0, 0, 78),
          printGIL(GIL),
          fail
       )
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% cFS(GIL, ModList, GlobalTypeList, Err)
%
% looks for each module in 'ModList' what it
% exports (wrt GIL) and looks if all subterms
% of a function signature are also exported
% by the module, e.g. if
% f::list(A)->tree(pair(A))->int->bool
% is exported by a module, then this module also
% has to export list, tree, pair, int and bool,
% where types occuring in the GlobalTypeList
% do not have to be exported. A subterm that
% should but is not exported will be put into
% 'Err'; with a findall- or setof-predicate
% all solutions can be computed.
% Entities in a function's signature have to
% be data types, not constructors.
% One has to use data constructors with their
% correct arity; otherwise there'll be an error.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cFS(GIL, ModList, GlobalTypeList, Err):-
  member(Module, ModList),
  makeModExportsList(GIL, Module, Exports),
  member(f(Name,Sig,_,_,_,_), Exports),

  getSubtermsAndArity(Sig, Subterms),
  % Subterms \== 0, all Heads of all subterms in Sig.
  member((Subt, SubtAr), Subterms),

  if(
       (
          notmember(Subt, GlobalTypeList),
          notmember((Subt, SubtAr), Exports)
       ),
       (
          name('*** Error: function ', S1),
          name(Name,S2),
          append(S1,S2,S3),
          name(' uses ', S4),
          append(S3, S4, S5),
          name(Subt, S6),
          append(S5, S6, S7),
          name('/', S8),
          append(S7, S8, S9),
          name(SubtAr, S10),
          append(S9, S10, S11),
          name(' in module ', S12),
          append(S11, S12, S13),
          name(Module, S14),
          append(S13, S14, S15),
          name(Err,S15)
       ),
       Err=no
    ).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% getArity(Term, Accu, Arity)
%
% computes the arity of a function signature of the form A->B->C->...
% -> is right-associative, i.e. a->b->c=a->(b->c)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

getArity(T, ArOld, ArNew):-
  var(T),    % T has not to be bound!!!!
  !,
  ArNew is ArOld+1.
getArity((_->Bvar), ArOld, ArNew):-
  !,
  ArTmp is ArOld+1,
  getArity(Bvar, ArTmp, ArNew).
getArity(_, ArOld, ArNew):-!,
  ArNew is ArOld+1.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% notmember(K, ExpL)
%
% checks if there is a datatype declaration for K=(Subt,Ar) in 'ExpL', 
% i.e. for the functor 'Subt' with arity 'Ar'.
% If K is not of the given form, it checks, if K literally is in 'ExpL'.
% Attention: no cut is allowed in this predicate as it's used for nondeter-
% ministic search.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

notmember(_,[]).
notmember(K,[X|Xs]):-
  if(
       K=(Subt,Ar),
       true,
       Subt=K
    ),
  if(
       X=..[d,XName,_,_],
       if(
	    XName=..[=,XLeft,_],
	    functor(XLeft, XF, XAr),
	    functor(XName, XF, XAr)
	 ),
       (
	  XF=X, 
	  if(var(Ar), (Ar=noarity, XAr=noarity), XAr=Ar)
       )
    ),
  ((Subt\==XF);(XAr\==Ar)),
  notmember(K,Xs).


  
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeDoubleDecls(GIL, NewGIL)
%
% removes all constructor declarations c(Name, OrigMod, OrigName)
% if there exists a datatype declaration for Name. Therefore, an
% entity at the right side of a data declaration
% "data l=r1;r2;...;rn"
% (an 'entity' means all heading functors of all subterms of 
% all r{i})
% will be handled as a data type constructor if it is NOT declared
% differently.
%
% The idea behind this is that all subterms of the right side (more
% precisely: all subterm's heads) are handled as constructors and
% copied in the export list of the current module at first. In
% the process of building the export table they may be removed.
%
% As we allow data declarations of the form "data name=name"
% (e.g. "data unit=unit"), there will only be one entry in the
% symbol table for unit - as data type. Therefore, renamings of
% 'unit' rename both, the data type AND the data type constructor.
% If 'unit' is imported, then both entities are imported: data tye
% and constructor.
%
%
% needs rDDLevel2/2, buildNewImpAndExp/2, correctExp/3
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeDoubleDecls(GIL, NewGIL):-
  setof((Fil,NewS), rDDLevel2(GIL, (Fil,NewS)), NewGIL).

rDDLevel2(GIL, (File, NewSet)):-
  member((File, ImpAndExp), GIL),
  setof(NewImpAndExp, buildNewImpAndExp(ImpAndExp, NewImpAndExp), NewSet).

buildNewImpAndExp(ImpAndExp, (Mod, Imp, NewExp, Used)):-
  member((Mod, Imp, Exp, Used), ImpAndExp),
  extractConstructors(Exp, [], CList),
  correctExp(CList, Exp, NewExp).

correctExp([], L, L).
correctExp([c(Name, OM, ON)|Rest], Exp, New):-
  if((member(d(X=_,_,_),Exp),X=..[Name|_]),
      (delete(Exp, c(Name,OM,ON), TmpExp)),
      TmpExp=Exp
    ),
  if((member(d(Z,_,_),TmpExp),Z=..[Name|_]),
     delete(TmpExp, c(Name,OM,ON), TmpExp2),
     TmpExp2=TmpExp
    ),
  correctExp(Rest, TmpExp2, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeImports(GIL, ModList, Accu, NewGIL), remImp/4
%
% removes the Imports of the modules in 'ModList' in GIL (i.e. replaces
% them by []) and returns the result in 'NewGIL'.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeImports([], _, L, L).
removeImports([(File, ModsInFile)|Rest], ModList, Accu, NewGIL):-
  remImp(ModsInFile, ModList, [], Tmp),
  ownappend(Accu, [(File, Tmp)], Tmp2),
  removeImports(Rest, ModList, Tmp2, NewGIL).
remImp([], _, L, L).
remImp([(Mod, Imp, Exp, Used)|Rest], ModList, Accu, New):-
  if(
       (ownmember(Mod, ModList), Used=used),
       NewImp=[],
       NewImp=Imp
    ),
  ownappend(Accu, [(Mod, NewImp, Exp, Used)], Tmp),
  remImp(Rest, ModList, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% removeModules(GIL, ModList, Accu, NewGIL), remMod/4
%
% removes the modules in ModList from GIL and returns the result
% in NewGIL
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

removeModules([], _, L, L).
removeModules([(File, ModsInFile)|Rest], ModList, Accu, NewGIL):-
  remMod(ModsInFile, ModList, [], Tmp),
  ownappend(Accu, [(File, Tmp)], Tmp2),
  removeModules(Rest, ModList, Tmp2, NewGIL).
remMod([], _, L, L).
remMod([(Mod, Imp, Exp, Used)|Rest], ModList, Accu, New):-
  if(
       ownmember(Mod, ModList),
       NewEntry=[],
       NewEntry=[(Mod, Imp, Exp, Used)]
    ),
  ownappend(Accu, NewEntry, Tmp),
  remMod(Rest, ModList, Tmp, New).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% mergeTables(MergeFrom, MergeTo, Result)
%
% merges to symbol tables MergeFrom, MergeTo into Result. Entries
% that occur in MergeFrom (marked 'used') are inserted in 
% MergeTo (i.e. Result contains MergeFrom completely and the rest
% of MergeTo - the entities that have not been overwritten).
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% first arg. has priority!
mergeTables([], L, L).
mergeTables([(File,ModsInFile)|Rest], MergeInto, Result):-
  if(
       ownmember((File, ModsInIntoFile), MergeInto),
       (
	  mTab(ModsInFile,ModsInIntoFile, NewImpExp),
	  delete(MergeInto, (File, ModsInIntoFile), MergeInto2),
	  ownappend(MergeInto2, [(File, NewImpExp)], Tmp)
       ),
       % file not yet in symbol table: append!
       ownappend(MergeInto, [(File, ModsInFile)], Tmp)
    ),
  mergeTables(Rest, Tmp, Result).


% all modules marked 'used' in the first arg. are copied into the
% second, where entries with the same Module tag previously have
% been deleted: first arg has priority!
mTab([], L, L).
mTab([(Mod, Imp, Exp, used)|Rest], Into, Result):-
  if(
       ownmember((Mod, I1, E1, Used), Into),
       delete(Into, (Mod, I1, E1, Used), Into2),  %never fails
       Into2=Into
    ),
  ownappend([(Mod,Imp,Exp,used)], Into2, Tmp),
  mTab(Rest, Tmp, Result).
mTab([(_,_,_,unused)|Rest], Into, Result):-
  mTab(Rest, Into, Result).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% unused predicates ...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% readPreludesDefinition(PrelGIL, PrelDefs)
%
% reads the prelude, builds a partial symbol table (stored in 
% PrelGIL), and computes the preludes translation table.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

readPreludesDefinitions(PrelGIL, PrelDefs):-
  % 4th component: checked; not interesting.
  readHeaders(prelude, GILTmp, [], _, 'creating preludes'),
  buildAndCheckImportChains(GILTmp, prelude, ImportChain),
  checkAndExpand(GILTmp, ImportChain, PrelGIL),
  checkGenerally(PrelGIL),
  PrelGIL=[(_, [(_,_,E,_)])],
  buildTranslationTable([(prelude,E)], prelude, PrelDefs).





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Tests ...
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%start:-
% op(880,xfy,(;)),
% op(848,xfy,(->)),
% op(848,xfy,(::)),
% % read interfaces
%  pass1(GIL, ImportChain, Checked),
%  write('Pass 1 done ...'),nl,
%  % read implementations and complete symbol table;
%  % the resulting symbol table contains the implementations'
%  % imports
%  pass2(Checked, [], EntityList, GIL, NewGIL, Checked, NewChecked, [], CheckedFiles, KnownNames),
%  write('Pass 2 done ...'),nl,
%  pass3(KnownNames, EntityList, daswilleiner),
%  write('Pass 3 done ...').

pass3(KnownNames, EntL, Mod):-
  buildTranslationTable(KnownNames, Mod, Translations),nl,nl,
  %write('Definitions'),nl,write(Translations),nl,
  renF('(data ddd(AB ?? HH)==f(B) ?? eee++[A] ?? ddd;tree(A);jk(wuwu))',Translations,FF,daswilleiner),
  getSubterms(FF,L2),nl,nl,write(L2),
  nl,nl,write(FF),nl,nl,
  renF((f::int->constraint->bool/\l),Translations, GG, daswilleiner),
  nl,nl,write(GG),nl,nl,
  getSubterms(GG,L),write(L),
  declareImplOperators(Mod, EntL). %,     %the operators declared in the implementation

% all parameters are results
%initModSys:-
%  op(880,xfy,(;)),
%  op(848,xfy,(->)),
%  op(848,xfy,(::)),
%  pass1(GIL, ImportChain, Checked, PreludesExp),
%  removeOperators(PreludesExp, [], PrelExp),
%  pass2(Checked, [], EntityList, GIL, _, Checked, NewChecked, [], _, KnownNames,PrelExp),
%  ownappend([prelude], NewChecked, NC),
% ownappend([(prelude, PrelExp)], KnownNames, KNs),
%  readImplementations(NC, KNs, EntityList, []).





%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%




:-op(1100,xfy,(;)).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% READIN %%%%


clearDataStructures :-
	seen,
	retractall(constructor(_,_,_,_)),
	retractall(function(_,_,_)),
	retractall(tree(_,_)),
	retractall(typen(_,_)),
	retractall(rule(_,_)),
	retractall(temptype(_,_,_)),
	retractall(temprule(_,_)),
	retractall(functionTreeFlag(_,_)),
        retractall(evaltree(_,_)),
	retractall(treeStrategy(_)),
	retractall(isExternal(_)),
        retractall(root_module(_)),
        retractall(noInterface(_)),
        retractall(modExportsMod(_,_)),
	retractall(prelpath(_)),
        retractall(preldefs(_)),
        retractall(symbtab(_)),
        retractall(currline(_)),
        retractall(entityNotVariable(_)),
        retractall(lineToBeStored(_,_)),
        retractall(actualConstructors(_)),
	retractall(actualRootConstructors(_)),
        retractall(rootsymbtab(_)),
        retractall(modImportsMod(_)),
        retractall(singlefile(_)),
	retractall(searchLambdaList(_)),
        retractall(generalError).

rr:-consult('readin').

%%%%%%%% Predefined

initPredefined :- treeStrat, assertPredefinedTypes.

treeStrat:-assertz(treeStrategy(standard)).  %zu Beginn ist Baumstrategie standard

assertPredefinedTypes:-assertz(typen(int,[])). %Hack, damit int als Typ erkannt wird


%%%%%%%%

setPreludesPath(PPath):-
  safe(retractall(prelpath(_))),
  assertz(prelpath(PPath)).
initAll:-
        clearDataStructures,
        initPredefined.



readProg(File, PrelPath, KnownNames, ResultGIL, AllKnownNames):-
        clearDataStructures,
        initPredefined,
	!,
        setPreludesPath(PrelPath),
        readAll(File, KnownNames2, ResultGIL, AllKnownNames),
        % difference between KnownNames2 and KnownNames:
        % in KnownNames2 there may be constructors that 
        % actually are variables.
        if(generalError, (retractall(generalError), !,fail), true),
        if(
             rootsymbtab(KnownNames),
             true,
             KnownNames=KnownNames2
          ),
        write('Typecheck'),flush_output,!,
	typeCheckAll(KnownNames),
	write('finished.'),nl,flush_output,
	retract(currline(_)),
        removeTempFiles.



store(D) :-
	var(D), !,
	writeReadError("Wrong definition in source program",[]).
store(end_of_file) :-
	!.
store((import _)) :-!.
store(infix(Prec,Op))  :- op(Prec,xfx,Op).
store(infixl(Prec,Op)) :- op(Prec,yfx,Op).
store(infixr(Prec,Op)) :- op(Prec,xfy,Op).
store((data TypeName = Constructors)) :- !,
	storeConstructors(TypeName,Constructors,_E).
store((F :: Type)) :- !,
	storeFunction(F,Type).
store((F eval T)) :- !,
	storeTree(F,T).
store((external F::Type)):-!,
	assertz(isExternal(F)),
	storeFunction(F,Type).

% NEW * NEW * NEW
store((L if C = R)):-
    var(R),
    !,
    makeConditionalList(C,R,Rhs),
    storeRule(L,condList(Rhs)).

store((L if C = R)) :- !,
    makeConditionalList(C,R,Rhs),
    storeRule(L,condList(Rhs)).
	
store((L if C = R where Locals)) :-
    makeConditionalList(C,R,Rhs),
    storeRule(L,whererule(condList(Rhs),Locals)).


% OLD * OLD * OLD
%store((L if C = R)):-
%        var(R), 
%        !, 
%        createGuardedExpression(C,R,Cond),
%        storeRule(L,Cond).
%
%store((L if C = R if C1 = MoreClauses)) :- !,
%	splitConditions(C,R,C1,MoreClauses,Rules),   % split multiple constraints 
%        if(checkHaskell(Rules),        % disjunctive constraints in haskell notation ?
%            (cascade(Rules,NewRule),   % then join rules to ONE if-then-else-cascade
%             writeterm(L=NewRule),nl,
%             storeRule(L,NewRule)      
%            ),
%            storeRest(L,Rules)          % else store rules separately
%           ).
%        createGuardedExpression(C,R,Cond),
%         storeRule(L,Cond),
%write('cond1 = '),write(Cond),nl,
%	 store((L if C1 = MoreClauses)).
% predicate or function on right side
%
%store((L if C = R)):- !,
%	createGuardedExpression(C,R,Cond),
%write('cond2 = '),write(Cond),nl,
%        storeRule(L,Cond).
%store((L if C = R where Locals)) :- var(R),!,
%	createGuardedExpression(C,R,Cond),
%	storeRule(L,whererule(Cond,Locals)).
%store((L if C = R if C1 = MoreClauses where Locals)) :- !,
%	store((L if C = R where Locals)),
%	store((L if C1 = MoreClauses where Locals)).
%store((L if C = R where Locals)) :- !,
%	createGuardedExpression(C,R,Cond),
%	storeRule(L,whererule(Cond,Locals)).

store((L = R where Locals)) :- !,
	store((L = whererule(R,Locals))).
store((L=R)) :- !,
	storeRule(L,R).
store((default P)):-!,
	storeEvalStrat(P).

store(_D) :-
	writeReadError("Wrong definition in source program",[]).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% collect all guards and all right hand sides and return them in lists
makeConditionalList(C,R,[NewR]):-var(R),!, %rhs is a variable, then we are finished
    transformCond(C,R,NewR).

% this case only matches if Y contains no "if C1=MoreClauses", i.e.
% only if the rhs is a equality constraint and no rules follow.
% We have to match this case explicitely, because otherwise
% X will be bound to "R if C1 = MoreClauses" in the next rule!
makeConditionalList(C,X=Y,[NewR|Rest]):-var(X),
	transformCond(C,X=Y,NewR).

makeConditionalList(C,R if C1 = MoreClauses,[NewR|Rest]):-  % otherwise test if the rhs
	transformCond(C,R,NewR),                                         % contains further rules
    makeConditionalList(C1,MoreClauses,Rest).

makeConditionalList(C,R,[NewR]):-    % if rhs does not contain further rules, end
    transformCond(C,R,NewR).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% transformCond(C,transformedC)
%
% check V in "V localIn C". Keep the 'localIn' because it is needed

transformCond(C,R,cond(C,R)) :- var(C), !.

transformCond(V localIn C,R,NewV localVars cond(C,R)):- !,
    ifc(var(V),NewV=[V],
            ifc(nobound(V),
                NewV=V,
                writeReadError(" ~w is not a valid parameter for 'localIn'.~n Expected: single variable or a list of variables!",[V]))).
				  
transformCond(C,R,cond(C,R)) :- !.


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% splitConditions
% split multiple Conditions into a list of Pairs: (Cond,Rule)
%
%splitConditions(C,R,C1,R1 if C2 = MoreClauses,[(C,R)|Rules]):- 
%         splitConditions(C1,R1,C2,MoreClauses,Rules).
%splitConditions(C,R,C1,R1,[(C,R),(C1,R1)]).
%
% checkHaskell
% test if Haskell-notation was used
%
%checkHaskell([]).
%checkHaskell([({_C},_)|Rest]):- !,
%          fail.
%checkHaskell([(_V localIn {_C},_)|Rest]):- !,
%		  fail.
%checkHaskell([(_V localIn _C,_)|Rest]):- !,
%          fail.
%checkHaskell([(_C,_)|Rest]):- 
%          checkHaskell(Rest).
% 
% join multiple constraint-rules to ONE if-then-else rule
%
%cascade([(C,R)|[]],if C then R else failed).
%cascade([(C,R)|Rest],if C then R else E):-
%         cascade(Rest,E).
%
% store rules separately
%
%storeRest(_L,[]).
%storeRest(L,[(C,R)|Rules]):-
%          store((L if C = R)),storeRest(L,Rules).



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% createGuardedExpression(C,R,cond(..))
%
% - translates a boolean condition "b" into a constraint "b=true"
% - if condition is just a constraint, create a guarded expression
%     cond(C,R)
%   if condition is of kind  "V localIn C", create a guarded expression
%     V localVars (V,C,R). "localIn" instead of "local.. in" is only
%     necessary for correct readin (precedences of operators)
%  
%   So the local variables declared for C and R are declared on front of cond

createGuardedExpression(C,R,cond({C=true},R)) :- var(C), !.

createGuardedExpression(_V localIn C,_,_) :- var(C),!,
	writeReadError("Local variable declaration for condition/guard and right side/body~nonly allowed for a constraint condition/guard!",[]).

createGuardedExpression(V localIn {C},R,NewV localVars cond({C},R)) :- !,
	ifc(var(V),NewV=[V],
            ifc(nobound(V),
                NewV=V,
                writeReadError(" ~w is not a valid parameter for 'localIn'.~n Expected: single variable or a list of variables!",[V]))).

createGuardedExpression(V localIn C,R,NewV localVars cond({C=true},R)):- !,
    ifc(var(V),NewV=[V],
            ifc(nobound(V),
                NewV=V,
                writeReadError(" ~w is not a valid parameter for 'localIn'.~n Expected: single variable or a list of variables!",[V]))).
				  
createGuardedExpression({C},R,cond({C},R)) :- !.
createGuardedExpression(C,R,cond({C=true},R)).


%-------------------------------------------------------

%%% Verarbeitet eine neue Typdefinition:
%%%   Type = neuer Typname
%%%   Cons = Liste der Konstruktordefinitionen
%%% wird gespeichert als Fakten:
%%%   constructor(Konstruktorname,Stelligkeit,Typ,Typname)
%%%   typen(Type,Liste der Konstruktornamen)

storeConstructors(Type,Cons,Erg):-
	storeConstructors2(Type,Cons,Erg),
	assertz(typen(Type,Erg)).

storeConstructors2(Type,(Cons;Constructors),[ConsName|Xs]) :- !,
	storeConstructor(Type,Cons,ConsName),
	storeConstructors2(Type,Constructors,Xs).
storeConstructors2(Type,Cons,[ConsName]) :-
	storeConstructor(Type,Cons,ConsName).

storeConstructor(Type,ConsDecl,C) :-
	nonvar(ConsDecl),!,
	functor(ConsDecl,C,N),
	ConsDecl =.. [_|ArgTypes],
	buildCurryType(ArgTypes,Type,CurryType),
	assertz(constructor(C,N,CurryType,Type)).
storeConstructor(Type,ConsDecl,_) :-
	writeReadError("Illegal constructor declaration ~w in datatype ~w",[ConsDecl,Type]).

buildCurryType([],Type,Type).
buildCurryType([Arg|Args],Type,(Arg->CurryType)) :-
	buildCurryType(Args,Type,CurryType).

%----------------------------------------------------------

%%% Verarbeitet eine Baum-Definition
%%%   F : Funktionsname
%%%   Tree : die Baumdefinition
%%% wird gespeichert als:
%%%   evaltree(F,Tree)

storeTree(F,Tree) :-
	if(evaltree(F,Tree1),
	   writeReadError("Eval annotation for function '~w' already defined: '~w'",[F,Tree1]),
	   assertz(evaltree(F,Tree))).

%----------------------------------------------------------

%%% Verarbeitet eine Typangabe einer Funktion
%%%   F : Funktionsname
%%%   Type : Typ
%%% wird gespeichert als:
%%%   temptype(F,Stelligkeit,Type)

storeFunction(F,_) :-
	function(F,_,_),!,writeReadError("Function '~w' already defined",[F]).
storeFunction(F,Type) :-
	findArity(Type,N),
	assertz(temptype(F,N,Type)),
	storeFunctionTreeFlag(F).
storeFunction(F,_,_) :-
	writeReadError("Illegal declaration of function '~w'",[F]).



%----------------------------------------------------------

%%% Verarbeitet eine Regelangabe
%%%   L : linke Seite
%%%   R : rechte Seite
%%% wird gespeichert als:
%%%   temprule(L,R)


storeRule(L,_R) :- var(L),!,
	writeReadError("Variable as lhs not allowed",[]).
storeRule(L,_R) :-
       	L=..[F|_],function(F,_,_),!,writeReadError("Function '~w' already defined",[F]).
storeRule(L,R) :-
	functor(L,F,_),
	storeFunctionTreeFlag(F),
	transformExpr(R,TR),
%	writeterm(L=TR),nl,
	assertz(temprule(L,TR)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% transform(Expr,NewExpr)
%
% - transforms an expression in the internal form that
%   will be computed.
% - transform all (if A then B else C) into ite(A,B,C),
% - transform all {C1,...,Cn} (n>0) into C1/\.../\Cn,
% - transform all "local L in T" into "L localVars T"
%   and if L is a single variable, into "[L] localVars T". Report syntactic errors.
%   T may not be a variable!
% - transform  all (choice c1 -> e1;..cn->en) into choice([b1,..,bn])
%   with bi = V localVars (c,ei) if ci = V localIn c
%        bi = (ci,ei)  otherwise
%
%   So the local variables declared for C and R are declared on front of cond.
%   Compare "createGuardedExpression"


transformExpr(E,E) :- var(E), !.
transformExpr({E},E) :- var(E), !.
transformExpr(local X,NewV localVars NewT):-nonvar(X),X=(V in T),nonvar(T),!,
	ifc(var(V),NewV=[V],
            ifc(nobound(V),
                NewV=V,
                writeReadError(" ~w is not a valid parameter for 'local'.~n Expected: single variable or a list of variables!",[V]))),
        transformExpr(T,NewT).

transformExpr(local X,_):-!,writeReadError("Wrong use of local declaration at 'local ~w'.~nSytnax is 'local List in T, T not a variable.'.",[X]).
transformExpr(X in Y,_):-!,writeReadError("Wrong use of local declaration '~w in ~w'.~nSytnax is 'local List in T, T not a variable.'.",[X,Y]).

transformExpr((if Then),'$ite'(TA,TB,TC)) :-
	nonvar(Then), Then = A then Else,
	nonvar(Else), Else = B else C,
	!,
	transformExpr(A,TA),
	transformExpr(B,TB),
	transformExpr(C,TC).

% first translate "," into "/\", THEN transform the whole /\-expression,
% possibly with a local-operator at the beginning.
% It's done this way to avoid binding problems with a local-operator
% at the beginning of a ","-sequence. The old method would
% transform "{local Z in vater(X,Z)=true, vater(Z,Y)=true}"
% into "(local Z in vater(X,Z)=true)/\vater(Z,Y)=true"
% and the brackets are wrong!!!

transformExpr({C,Cs}, NewAndTerm):-
  var(C),
  !,
  createAnds((C,Cs),AndTerm),!,
  transformExpr(AndTerm,NewAndTerm). 
  
transformExpr({local List in C,Cs},NewAndTerm) :- !,
	createAnds((C,Cs),AndTerm),!,
        transformExpr(local List in AndTerm,NewAndTerm). 

transformExpr({C,Cs},NewAndTerm) :- !,
	createAnds((C,Cs),AndTerm),!,
        transformExpr(AndTerm,NewAndTerm). 

createAnds(C,C):-var(C),!.
createAnds((C,Cs),C/\NewCs):-
	createAnds(Cs,NewCs).
createAnds(C,C).

%transformExpr({C,Cs},TC/\TCs) :- !,  
%	transformExpr(C,TC),
%	transformExpr({Cs},TCs).

transformExpr({C},TC) :- !,
	transformExpr(C,TC).
%transformExpr((choice Args),choice(ArgList)):-!,
%	transformChoiceArgs(Args,ArgList).
transformExpr(E,TE) :-
	E =.. [F|Args],
	transformExprList(Args,TArgs),
	TE =.. [F|TArgs].

transformExprList([],[]).
transformExprList([E|Es],[TE|TEs]) :-
	transformExpr(E,TE),
	transformExprList(Es,TEs).


%transformChoiceArgs((C->E;RestArgs),[NewBranch|ArgList]):-!,
%        createGuardedExpression(C,E,Cond),
%	decideOnCondition(Cond,NewBranch,RestArgs,ArgList).

%decideOnCondition(V localVars cond(C,E),V localVars (C1,E1),RestArgs,ArgList):-
%	transformExpr(C,C1),
%        transformExpr(E,E1),
%        transformChoiceArgs(RestArgs,ArgList).

%decideOnCondition(cond(C,E),(C1,E1),RestArgs,ArgList):-
%	transformExpr(C,C1),
%        transformExpr(E,E1),
%        transformChoiceArgs(RestArgs,ArgList).

%transformChoiceArgs((C->E),[NewBranch]) :-!,
%        createGuardedExpression(C,E,Cond),
%	decideOnCondition(Cond,NewBranch).

%decideOnCondition(V localVars cond(C,E),V localVars (C1,E1)):-
%	transformExpr(C,C1),
%        transformExpr(E,E1).

%decideOnCondition(cond(C,E),(C1,E1)):-
%	transformExpr(C,C1),
%        transformExpr(E,E1).

%transformChoiceArgs(_,_):-!,
%	writeReadError("Illegal declaration of choice construct.",[]).




%storeFunctionTreeFlag
%speichert zu der Funktion das momentan gltige Baumauswertungsstrategie-Flag ab
%falls die Strategie "standard" ist, wird nichts gespeichert
storeFunctionTreeFlag(Func):-
	if(functionTreeFlag(Func,_),  %wurde schon eins gespeichert, dann gilt dieses. Nicht ersetzen
	   true,
	   (treeStrategy(P),	%strategyflag abfragen
            assertz(functionTreeFlag(Func,P))     %und zu Funktion speichern
	   )
	  ).



%----------------------------------------------------------

%%% Verarbeitet ein Baumauswertungsstrategie-Flag
%%% wird gespeichert als:
%%% treeStrategy(P). 



storeEvalStrat(P):-
	retractall(treeStrategy(_)),!,
	if(var(P),
	   writeReadError("Tree evaluation strategy must be standard, residuate or narrow!",[]),
	   (checkFlag(P),
	    assertz(treeStrategy(P)))).

checkFlag(standard).
checkFlag(narrow).
checkFlag(residuate).
checkFlag(_):-writeReadError("Tree evaluation strategy must standard, residuate od narrow!",[]).



%----------------------------------------------------------------------------------
%--- Tools
%---

writeReadError(Format,Args) :-
	currline(L),bindVarsInTerm([L|Args],NewArgs),
	append("*** Readin-Error: ~w~n",Format,NewFormat),
	format(NewFormat,NewArgs),fail.

findArity(X,0) :- var(X),!.

findArity((_L->R),N) :- !,
	findArity(R,N1), N is N1+1.
findArity(_,0).

consType(C,int):-integer(C),!.
consType(C,T) :- constructor(C,_,_,T).

isType(T) :- nonvar(T),typen(T,_).
isCons(C,N) :- constructor(C,N,_,_).
isCons(C,0) :- integer(C),!.
isCons(C,0) :- float(C),!.
isFunc(F,N) :- function(F,N,_).

fArity(F,Arity):-function(F,Arity,_).
cArity(C,Arity):-constructor(C,Arity,_,_).
cArity(C,0)    :-integer(C),!.

arity(S,Arity):-fArity(S,Arity);cArity(S,Arity).

%ergType
%Ergebnistyp einer Funktion abfragen
ergType(F,IType) :-
	function(F,N,T),!,
	ergType(F,N,N,T,IType,_).

ergType(C,IType) :-
	constructor(C,N,T,_),!,
	ergType(C,N,N,T,IType,_).

ergType(_F,_N,0,T2,T2,_) :- !.
ergType(_F,_N,1,(_T1->T2),T2,_) :- !.
% das T2 ist der Unterschied zu ithType

ergType(F,N,I,(_T1->T2),IType,OrigI) :- !,
	I1 is I-1,
	ergType(F,N,I1,T2,IType,OrigI).
ergType(F,N,_I,_,_,OrigI) :-
	write('*** Interner Fehler: Zugriff auf '),write(OrigI),
	write('. Parameter der '),write(N),
	write(' stelligen Funktion/Konstruktor '),write(F),fail.



% Typ des i-ten Parameters von Func oder Constr feststellen
ithType(F,I,IType) :-
	function(F,N,T),!,
	ithType(F,N,I,T,IType,I).

ithType(C,I,IType) :-
	constructor(C,N,T,_),!,
	ithType(C,N,I,T,IType,I).

ithType(_F,_N,1,(T1->_T2),T1,_) :- !.
ithType(F,N,I,(_T1->T2),IType,OrigI) :- !,
	I1 is I-1,
	ithType(F,N,I1,T2,IType,OrigI).
ithType(F,N,_I,_,_,OrigI) :-
	write('*** Interner Fehler: Zugriff auf '),write(OrigI),
	write('. Parameter der '),write(N),
	write(' stelligen Funktion/Konstruktor '),write(F),fail.
















