-- a simple counter demo for the Tcl/Tk library
-- here: run the counter in a constraint

import Tk
import Read

counter_widget =
     TkCol [] [
       TkLabel [TkText "A simple counter:"],
       TkEntry [TkRef val, TkText "0", TkBackground "yellow"],
       TkRow [] [TkButton (tkCUpdate incrText val) [TkText "Increment"],
                 TkButton (tkCSetValue val "0")    [TkText "Reset"],
                 TkButton tkCExit                  [TkText "Stop"]]]
     where val free

           incrText s = show (readInt s + 1)

main = openWish "Counter Demo" >>= runCounterOnPort

runCounterOnPort wport | runWidgetOnPort counter_widget wport
                       = done

