-- This program is a demo of the TkMatrix construct
-- A Matrix is useful, when widgets should oriented in a table-like style.

import Tk
import Ports
import System
import Read
import ReadShowTerm
import IOExts

data Person = Person String String String String String String String String 

widget (Person name1 fname1 uni1 city1 street1 nr1 zip1 country1) noe =
 TkCol [TkLeft] [
   TkRow []
     [TkLabel [TkText "Entry #"], TkLabel [TkRef nrlab,TkText "1"],
      TkLabel [TkText "/"], TkLabel [TkRef nrOfEntries,TkText (show noe)]],
   TkMatrix [TkLeft] 
     [
      [TkLabel [TkText "Surname:"], 
       TkEntry [TkRef name, TkWidth 30,TkFillX, TkText name1],
       TkLabel [TkText "Forename:"], 
       TkEntry [TkRef fname, TkWidth 30,TkFillX, TkText fname1]],
      [TkLabel [TkText "University:"], 
       TkEntry [TkRef uni, TkWidth 30,TkFillX, TkText uni1],
       TkLabel [TkText "City:"], 
       TkEntry [TkRef city, TkWidth 30,TkFillX, TkText city1]],
      [TkLabel [TkText "Street:"], 
       TkRow [TkLeft] 
             [TkEntry [TkRef street, TkWidth 30,TkFillX, TkText street1],
              TkLabel [TkText "Nr:"], 
              TkEntry [TkRef nr, TkWidth 5,TkFillX, TkText nr1]],
       TkLabel [TkText "Zip Code:"], 
       TkEntry [TkRef zip, TkWidth 30,TkFillX, TkText zip1]],
      [TkLabel [TkText "Country:"], 
       TkEntry [TkRef country, TkWidth 30,TkFillX, TkText country1]]
     ],TkLabel [TkFillX],
   TkRow []
     [TkConfigButton new  [TkText "New"], TkLabel [TkFillX],
      TkConfigButton prev [TkRef prevbutton, TkText "<<", TkActive False],
      TkLabel [TkFillX],
      TkButton save [TkText "Save"], TkLabel [TkFillX],
      TkConfigButton next [TkRef nextbutton, TkText ">>", TkActive (noe>1)],
      TkLabel [TkFillX],
      TkButton tkExit [TkText "Exit"]
     ]
   ]
 where street,zip,name,fname,uni,city,nr,country,nrlab,
              nextbutton,prevbutton,nrOfEntries free

       next wp =    getPerson (+1) wp         >>= \person 
                 -> setPerson (+1) person wp  >>= \number 
                 -> tkGetValue nrOfEntries wp >>= \noe_cont 
                 -> return $ (if number == readNat noe_cont
                              then [(nextbutton,TkActive False)]
                              else []) ++
                             [(prevbutton,TkActive True)]

       prev wp =    getPerson (+(-1)) wp         >>= \person 
                 -> setPerson (+(-1)) person wp  >>= \number 
                 -> return $ (if number == 1
                              then [(prevbutton,TkActive False)]
                              else []) ++
                             [(nextbutton,TkActive True)]

       getPerson f wp = readFile pFile >>= \fileconts ->
                        let persons = map readTerm (lines fileconts) in
                        tkGetValue nrlab wp >>= \nrlab_cont ->
                        return $ persons !! (f (readNat nrlab_cont) -1)
               
       setPerson f (Person pname pfname puni pcity pstreet pnr pzip pcountry) wp =
          tkSetValue name    pname    wp >>
          tkSetValue fname   pfname   wp >> 
          tkSetValue uni     puni     wp >>
          tkSetValue city    pcity    wp >>
          tkSetValue street  pstreet  wp >>
          tkSetValue nr      pnr      wp >>
          tkSetValue zip     pzip     wp >>
          tkSetValue country pcountry wp >>
          tkGetValue nrlab wp >>= \nrlab_cont ->
          let number = f $ readNat nrlab_cont in
          tkSetValue nrlab (show number) wp >>
          return number

       save wp = tkGetValue name wp    >>= \name_cont    ->
                 tkGetValue fname wp   >>= \fname_cont   ->    
                 tkGetValue uni wp     >>= \uni_cont    ->
                 tkGetValue city wp    >>= \city_cont    ->     
                 tkGetValue street wp  >>= \street_cont  ->       
                 tkGetValue nr wp      >>= \nr_cont      ->   
                 tkGetValue zip wp     >>= \zip_cont     ->    
                 tkGetValue country wp >>= \country_cont ->
                 tkGetValue nrlab wp   >>= \nrlab_cont   ->
                 tkGetValue nrOfEntries wp >>= \noe_cont ->
                 let number = readNat nrlab_cont 
                     person = Person name_cont fname_cont uni_cont 
                                     city_cont street_cont nr_cont 
                                     zip_cont country_cont 
                 in
                 if number > readNat noe_cont
                   then appendFile pFile (showTerm person ++ "\n")
                   else readCompleteFile pFile >>= \conts ->
                        let ls = lines conts in 
                        writeFile pFile 
                          (unlines (take (number - 1) ls ++ 
                                   [showTerm person] ++ 
                                    drop number ls))

       new wp = tkGetValue nrOfEntries wp >>= \noe_cont ->
                let max = readNat noe_cont in
                tkSetValue nrOfEntries (show $ max+1) wp >>
                setPerson (\_->max+1) empty wp >>
                appendFile pFile (showTerm empty ++ "\n") >>
                return [(prevbutton,TkActive True),
                        (nextbutton,TkActive False)]
             
main = appendFile pFile "" >>
       readFile pFile >>= \conts ->
       let exists = conts/="" in
       (if not exists 
         then writeFile pFile (unlines (map showTerm someCurryHeroes)) >>
              return someCurryHeroes
         else return (map readTerm (lines conts))) >>= \persons ->
       let person = head persons 
           nrOfEntries = length persons 
       in
       runWidget "A simple Entry Form in table Style" $ 
                 widget person nrOfEntries


pFile = "tmp.matrixdemodata" 

empty = Person "" "" "" "" "" "" "" ""

someCurryHeroes = 
  [Person "Hanus" "Michael" "Christian-Albrechts-University" "Kiel" "Ohlshausener Strae" "40" "D-24098" "Germany",
   Person "Antoy" "Sergio" "Portland State University" "Portland, Oregon" "SW 4th Avenue" "1900" "OR 97207-0751" "USA",
   Person "Vidal Oriola" "Germn F. " "Universidad Politcnica" "Valencia" "Camino de Vera" "s/n" "E-46022" "Spain",
   Person "Huch" "Frank" "Christian-Albrechts-University" "Kiel" "Ohlshausener Strae" "40" "D-24098" "Germany",
   Person "Brael" "Bernd" "Christian-Albrechts-University" "Kiel" "Ohlshausener Strae" "40" "D-24098" "Germany"]

