-- an implementation of radiobuttons with checkbuttons:

import Tk

-- column of radiobuttons:
-- (radioButtonCol <TkRef to radio> <labels> <command>)
radioButtonCol rbs names cmd
 | rbs =:= tk_gen_vars n  = TkCol [TkLeft] (gen_rb 0)
 where n = length names
       gen_rb i =
         if i==n
         then []
         else TkCheckButton [TkText (names!!i), TkRef (rbs!!i),
                             TkCmd (rbcmd (rbs!!i) (remove_ith i rbs) cmd)]
              : gen_rb (i+1)

-- radiobutton command:
-- if button selected -> deselect others and check constraint
rbcmd vsel vothers cmd wp =
  do sel <- tkGetValue vsel wp
     if sel=="1" then foldr (>>) done (map (\vo->tkSetValue vo "0" wp) vothers)
                 else done
     cmd wp

-- generate the n different unbound variables:
tk_gen_vars n = if n==0 then [] else var : tk_gen_vars (n-1)  where var free

-- remove i-th element in a list:
remove_ith _ [] = []
remove_ith i (x:xs) = if i==0 then xs else x : remove_ith (i-1) xs

tkGetRadioValue [] _ = return (-1)
tkGetRadioValue (r:rs) wp = tkGetValue r wp >>= \rval ->
  if rval=="1" then return 0
               else do rspos <- tkGetRadioValue rs wp
                       return (if rspos>=0 then rspos+1 else -1)

tkSetRadioValue [] _ _ = done
tkSetRadioValue (r:rs) i wp =
  do tkSetValue r (if i==0 then "1" else "0") wp
     tkSetRadioValue rs (i-1) wp



-- a simple example: a traffic light controller:
traffic =
 TkRow [] [
       radioButtonCol tr1 ["Red","Yellow","Green"] (excl tr1 tr2),
       radioButtonCol tr2 ["Red","Yellow","Green"] (excl tr2 tr1)]
  where tr1,tr2 free

excl tr1 tr2 wp =
 do sel <- tkGetRadioValue tr1 wp
    if sel>=0 then tkSetRadioValue tr2 (2-sel) wp else done

main = runWidget "Traffic Light" traffic

