-- temperature converter

import Tk
import Read

-- only a scale for Celsius:
temp_widget =
  TkCol [] [
    TkLabel [TkText "Temperature in Celsius:"],
    TkScale 0 100 [TkRef cels, TkCmd convert],
    TkRow [] [TkLabel [TkText "Fahrenheit: "],
              TkMessage [TkRef fahr, TkBackground "white"],
              TkLabel [TkText "Kelvin: "],
              TkMessage [TkRef kelv, TkBackground "white"]],
    TkButton tkExit [TkText "Stop"]]

 where
   cels,fahr,kelv free

   convert wp = do cs <- tkGetValue cels wp
                   let c = readInt cs
                   tkSetValue fahr (show (c * 9 `div` 5 + 32)) wp
                   tkSetValue kelv (show (c + 273)) wp

main = runWidget "Temperature Conversion" temp_widget



-- a scale for Celsius and a scale for Fahrenheit:
temp_widget2 =
  TkCol [] [
    TkLabel [TkText "Temperature in Celsius:"],
    TkScale 0 100 [TkRef cels, TkCmd convertC],
    TkRow [] [TkLabel [TkText "Fahrenheit: "],
              TkMessage [TkRef fahr, TkBackground "white"],
              TkLabel [TkText "Kelvin: "],
              TkMessage [TkRef kelv, TkBackground "white"]],
    TkLabel [TkText "Temperature in Fahrenheit:"],
    TkScale 0 212 [TkRef fscl, TkCmd convertF],
    TkButton tkExit [TkText "Stop"]]

 where
   cels,fahr,kelv,fscl free

   convertC wp = do cs <- tkGetValue cels wp
                    let c = readInt cs
                    tkSetValue fahr (show (c * 9 `div` 5 + 32)) wp
                    tkSetValue kelv (show (c + 273)) wp
                    tkSetValue fscl (show (c * 9 `div` 5 + 32)) wp

   convertF wp = do fs <- tkGetValue fscl wp
                    let c = ((readInt fs)-32) * 5 `div` 9
                    tkSetValue cels (show c) wp
                    tkSetValue fahr (show (c * 9 `div` 5 + 32)) wp
                    tkSetValue kelv (show (c + 273)) wp

main2 = runWidget "Temperature Conversion" temp_widget2

