:-module(filesystem, [prepareFiles/2, interfaceInFile/2, implementationInFile/2,removeTempFiles/0]).
%:-use_module(operators).
:-use_module(library(lists)).
:-use_module(library(system)).
:-use_module(io).

:-dynamic singlefile/1.


interfaceInFile(main, '.main'):-
  singlefile(dummy),
  !.
interfaceInFile(main, MainFile):-
  singlefile(MainFile),
  !.
interfaceInFile(Module, Module).

implementationInFile(main, '.main'):-
  singlefile(dummy),
  !.
implementationInFile(main, MainFile):-
  singlefile(MainFile),
  !.
implementationInFile(Module, Module).

removeTempFiles:-
  if(singlefile(dummy),
     (
        on_exception(
            _,
            (
	       if(file_exists('.main.fl'), delete_file('.main.fl'), true),
               if(file_exists('.main.fl'), delete_file('.main.int'), true)
	    ),
            true
        )
     ),
     true
    ),
  !.
     

prepareFiles(File, RootModule):-
  if(retractall(root_module(_)), true, true),
  if(retractall(singlefile(_)),true,true),
  name(File,NameL),

  % call the Curry->TasteCurry translater:
  if(environ('PAKCSHOME',ParsPath),true,(ParsPath='')),
  name(ParsPath,ParsPathL),
  append(ParsPathL,"/bin/parsecurry --fl ",ParsL),
  append(ParsL,NameL,ParsCmdL),
  name(ParsCmd,ParsCmdL),
%  write('Executing: '), write(ParsCmd), nl,
  system(ParsCmd),

  name('.fl',ExtL),
  append(NameL,ExtL,NameExtL),
  name(ImplFile,NameExtL),
  on_exception(ErrorMsg,
               see(ImplFile),
	       (print_error(ErrorMsg),fail)
              ),
  on_exception(
	         ErrorMsg,
		 read_term(Line,[variable_names(VarNames)]),
	         ( 
		    format(user_error,
			   "\n*** In file \c
			    '~w':\n",
			    [File]),
		    print_error(ErrorMsg),
		    seen,told,removeTempFiles,!,fail			
                 )
	      ),
  if(
       Line=(module(MainModule)),
       (
	  functor(MainModule, RootModule, _),
          (asserta(singlefile(File)),removeTempFiles),
          seen
       ),
       (
	  RootModule=main,
          asserta(singlefile(dummy)),
          tell('.main.fl'),
          write('module main.'),nl,
          \+ \+ (
                   bindTmpVars(VarNames),
                   writeq(Line)
                ),
          write('.'),nl,
          rLine(ImplFile),
          %write('endmodule.'),nl,
          seen,
          told
          % .main.int will be generated automatically
          %tell('.main.int'),
          %write('interface main.'),nl,
          %write('endmodule.'),nl,
          %told
       )
    ).


rLine(File):-
  %repeat,
  on_exception(
	         ErrorMsg,
		 (
                    read_term(Line,[variable_names(VarNames)]),
                    if(
                         Line==end_of_file,
                         (seen,told),
                         (
                             \+ \+ (
                                      bindTmpVars(VarNames),
                                      writeq(Line)
                                   ),
                            write('.'),
                            nl,
                            rLine(File)
                         )
                      )
                 ),
	         ( 
		    format(user_error,
			   "\n*** In file ~w:\n",
			    [File]),
                    print_error(ErrorMsg),
		    seen,told,removeTempFiles,!,fail			
                 )
	      ).

bindTmpVars([]).
bindTmpVars([(A=B)|Rest]):-
  B=A,
  bindTmpVars(Rest).

addExt(Name,Ext,NameExt) :-
	name(Name,NameL),
	name(Ext,ExtL),
	ownappend(NameL,ExtL,NameExtL),
	name(NameExt,NameExtL).




