:- module(ownlist, [ownmember/2, ownappend/3, remRen/3, removeFromList/3, reverseList/3,ownlast/2, ownflatten/2, makeListOfTuple/2, listifyArguments/2]).


:-use_module(library(lists)).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% ownmember, ownappend, removeFromList, reverseList, ownlast
%
% utilities for lists
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%ownmember(X,[X|_]):-!.
%ownmember(X,[_|L]):- ownmember(X,L).
ownmember(X,L):-member(X,L),!.
ownappend(A,B,C):-append(A,B,C),!.
%ownappend([],X,Y):-X=Y,!.
%ownappend(X,[],Y):-X=Y,!.
%ownappend([X|Xs],Ys,[Y|R]):-X=Y,ownappend(Xs,Ys,R).


% remove all r(_,_,_)'s from a list
remRen(r(R,T,M), List, Result):-
  member(r(R,T,M), List),!,
  ownappend(X,[r(R,T,M)|RestList],List),
  ownappend(X,RestList,TmpResult),
  remRen(r(_,_,_), TmpResult, Result).
remRen(_, L,L).


%removeFromList(El, List, Result):-
%	member(El, List),!,
%	ownappend(X,[El|RestList],List),
%	ownappend(X,RestList,TmpResult),
%	removeFromList(El, TmpResult, Result).
%removeFromList(_,List,List).

%reverseList([],L,L).
%reverseList([H|T], A, R):-
%  ownappend([H],A,K),
%  reverseList(T,K,R).

ownlast([], []). % ????
ownlast(E, [E|[]]):-!.
ownlast(E, [_|T]):-
  ownlast(E,T).

ownflatten([], []):-!.
ownflatten([L|R], Result):-
  !,
  ownflatten(L, FlatL),
  ownflatten(R, FlatR),
  ownappend(FlatL, FlatR, Result).
ownflatten(L, [L]).

makeListOfTuple(Tuple, List):-
  mLOT(Tuple, [], List).


mLOT((First, Rest), Accu, Result):-
  !,
  ownappend(Accu, [First], L),
  mLOT(Rest, L, Result).
mLOT(Last, Accu, Result):-
  ownappend(Accu, [Last], L),
  ownflatten(L, Result).

listifyArguments(L,R):-
  listifyArguments(L,[],R).

listifyArguments([], L, L).
listifyArguments([L|R], Accu, Result):-
  if(
       functor(L, _, 0),
       (
	  ownappend(Accu, [L], NL),
          listifyArguments(R, NL, Result)
       ),
       (
	  L=..[Functor|Args],
          ownflatten(Args, FlatArgs),
	  if(
               (FlatArgs==[..]),
               K=L,
               K=..[Functor|[FlatArgs]]
            ),
	  ownappend(Accu, [K], NL),
          listifyArguments(R, NL, Result)
       )
    ).


