--- This module contains the definition of data types to represent
--- entity/relationship diagrams

module ERD(ERD(..),ERDName,Entity(..),EName,Entity(..),
           Attribute(..),AName,Key(..),Null,Domain(..),
           Relationship(..),REnd(..),RName,Role,Cardinality(..)) where

import Time
import List(intersperse)

--- Data type for entity/relationship diagrams
data ERD = ERD ERDName [Entity] [Relationship]

type ERDName = String -- used as the name of the generated module


data Entity = Entity EName [Attribute]

type EName = String

data Attribute = Attribute AName Domain Key Null  

type AName = String

data Key = NoKey
         | PKey
         | Unique

type Null = Bool 

data Domain = IntDom      (Maybe Int) 
            | FloatDom    (Maybe Float)
            | CharDom     (Maybe Char)
            | StringDom   (Maybe String) 
            | BoolDom     (Maybe Bool)
            | DateDom     (Maybe CalendarTime)
            | UserDefined String (Maybe String)
            | KeyDom      String   -- later used for foreign keys


data Relationship = Relationship RName [REnd] 
 
type RName = String

data REnd = REnd EName Role Cardinality

type Role = String

-- fixed number (e.g., Exactly 1 = (1,1))
-- or range (e.g., Range 1 (Just 4) = (1,4), or Range 0 Nothing = (0,n))
data Cardinality = Exactly Int            
                 | Range Int (Maybe Int)

