------------------------------------------------------------------------------
--- Program to reduce the size of FlatCurry programs by replacing
--- the main FlatCurry file by a single FlatCurry file containing
--- no imports but all imported and potentially called functions.
---
--- @author Michael Hanus
--- @version January 2007
------------------------------------------------------------------------------

import List(intersperse)
import System
import CompactFlatCurry

-- Check arguments and call main function:
main = do
  args <- getArgs
  case args of
    [prog]              -> compactProgAndReplace [] prog
    ["-export",prog]    -> compactProgAndReplace [Exports] prog
    ["-main",func,prog] -> compactProgAndReplace [Main func] prog
    _ -> putStrLn $ "ERROR: Illegal arguments: " ++
                    concat (intersperse " " args) ++ "\n" ++
                    "Usage: compactflat [-export | -main func] <module_name>"

-- replace a FlatCurry program by a compactified version:
compactProgAndReplace options prog = do
  generateCompactFlatCurryFile (Required defaultRequired : options)
                               prog (prog++"_comp")
  system $ "mv "++prog++"_comp.fcy "++prog++".fcy"
  putStr $ "CompactFlat: compacted program '"++prog++".fcy' written.\n"

